/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.RecordCountTool;
import org.junit.Rule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.rules.TestName;

public class TestRecordCountTool {
    @Rule
    public TestName name = new TestName();
    @TempDir
    public File temporaryFolder;

    private File generateData(int numRecords) throws Exception {
        File tempFile = File.createTempFile("junit", null, this.temporaryFolder);
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            writer.create(schema, tempFile);
            writer.setSyncInterval(60);
            for (int i = 0; i < numRecords; ++i) {
                writer.append((Object)"foobar");
            }
        }
        return tempFile;
    }

    @Test
    void fileDoesNotExist() throws Exception {
        Assertions.assertThrows(FileNotFoundException.class, () -> {
            List<String> args = Collections.singletonList(new File(this.temporaryFolder, "nonExistingFile").getAbsolutePath());
            int returnCode = new RecordCountTool().run(System.in, System.out, System.err, args);
            Assertions.assertEquals((int)1, (int)returnCode);
        });
    }

    @Test
    void basic() throws Exception {
        List inputSizes = IntStream.range(0, 20).boxed().collect(Collectors.toList());
        for (Integer inputSize : inputSizes) {
            File inputFile = this.generateData(inputSize);
            List<String> args = Collections.singletonList(inputFile.getAbsolutePath());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int returnCode = new RecordCountTool().run(System.in, new PrintStream(out), System.err, args);
            Assertions.assertEquals((int)0, (int)returnCode);
            Assertions.assertEquals((Object)(inputSize.toString() + System.lineSeparator()), (Object)out.toString());
        }
    }

    @Test
    void multipleFiles() throws Exception {
        File f1 = this.generateData(20);
        File f2 = this.generateData(200);
        List<String> args = Arrays.asList(f1.getAbsolutePath(), f2.getAbsolutePath());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int returnCode = new RecordCountTool().run(System.in, new PrintStream(out), System.err, args);
        Assertions.assertEquals((int)0, (int)returnCode);
        Assertions.assertEquals((Object)("220" + System.lineSeparator()), (Object)out.toString());
    }
}

