/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import org.apache.avro.Protocol;
import org.apache.avro.tool.RpcProtocolTool;
import org.apache.avro.tool.RpcReceiveTool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestRpcProtocolTool {
    @ParameterizedTest
    @ValueSource(strings={"http", "avro"})
    void rpcProtocol(String uriScheme) throws Exception {
        String protocolFile = System.getProperty("share.dir", "../../../share") + "/test/schemas/simple.avpr";
        Protocol simpleProtocol = Protocol.parse((File)new File(protocolFile));
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        PrintStream p1 = new PrintStream(baos1);
        RpcReceiveTool receive = new RpcReceiveTool();
        receive.run1(null, p1, System.err, Arrays.asList(uriScheme + "://0.0.0.0:0/", protocolFile, "hello", "-data", "\"Hello!\""));
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        PrintStream p2 = new PrintStream((OutputStream)baos2, true, "UTF-8");
        RpcProtocolTool testObject = new RpcProtocolTool();
        testObject.run(null, p2, System.err, Collections.singletonList(uriScheme + "://127.0.0.1:" + receive.server.getPort() + "/"));
        p2.flush();
        Assertions.assertEquals((Object)simpleProtocol, (Object)Protocol.parse((String)baos2.toString("UTF-8")), (String)"Expected the simple.avpr protocol to be echoed to standout");
        receive.server.close();
    }
}

