/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.RecodecTool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestRecodecTool {
    @TempDir
    public File DIR;

    @Test
    void recodec() throws Exception {
        String metaKey = "myMetaKey";
        String metaValue = "myMetaValue";
        File inputFile = new File(this.DIR, "input.avro");
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        writer.setMeta(metaKey, metaValue).create(schema, inputFile);
        for (int i = 0; i < 100000; ++i) {
            writer.append((Object)("" + i % 100));
        }
        writer.close();
        File defaultOutputFile = new File(this.DIR, "default-output.avro");
        File nullOutputFile = new File(this.DIR, "null-output.avro");
        File deflateDefaultOutputFile = new File(this.DIR, "deflate-default-output.avro");
        File deflate1OutputFile = new File(this.DIR, "deflate-1-output.avro");
        File deflate9OutputFile = new File(this.DIR, "deflate-9-output.avro");
        new RecodecTool().run((InputStream)new FileInputStream(inputFile), new PrintStream(defaultOutputFile), null, new ArrayList());
        new RecodecTool().run((InputStream)new FileInputStream(inputFile), new PrintStream(nullOutputFile), null, Collections.singletonList("--codec=null"));
        new RecodecTool().run((InputStream)new FileInputStream(inputFile), new PrintStream(deflateDefaultOutputFile), null, Collections.singletonList("--codec=deflate"));
        new RecodecTool().run((InputStream)new FileInputStream(inputFile), new PrintStream(deflate1OutputFile), null, Arrays.asList("--codec=deflate", "--level=1"));
        new RecodecTool().run((InputStream)new FileInputStream(inputFile), new PrintStream(deflate9OutputFile), null, Arrays.asList("--codec=deflate", "--level=9"));
        try (DataFileReader reader = new DataFileReader(defaultOutputFile, (DatumReader)new GenericDatumReader());){
            Assertions.assertEquals((Object)metaValue, (Object)reader.getMetaString(metaKey));
        }
        Assertions.assertEquals((long)defaultOutputFile.length(), (long)nullOutputFile.length());
        TestRecodecTool.assertLessThan(deflateDefaultOutputFile.length(), nullOutputFile.length());
        TestRecodecTool.assertLessThan(deflate1OutputFile.length(), nullOutputFile.length());
        TestRecodecTool.assertLessThan(deflate9OutputFile.length(), nullOutputFile.length());
        TestRecodecTool.assertLessThan(deflate9OutputFile.length(), deflate1OutputFile.length());
    }

    private static void assertLessThan(long less, long more) {
        if (less >= more) {
            Assertions.fail((String)("Expected " + less + " to be less than " + more));
        }
    }
}

