/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.tool.IdlTool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIdlTool {
    @Test
    public void testWriteIdlAsSchema() throws Exception {
        String idl = "src/test/idl/schema.avdl";
        String protocol = "src/test/idl/schema.avsc";
        String outfile = "target/test-schema.avsc";
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        List<String> arglist = Arrays.asList(idl, outfile);
        new IdlTool().run(null, null, new PrintStream(buffer), arglist);
        Assertions.assertEquals((Object)this.readFileAsString(protocol), (Object)this.readFileAsString(outfile));
        String warnings = this.readPrintStreamBuffer(buffer);
        Assertions.assertEquals((Object)"Warning: Line 1, char 1: Ignoring out-of-place documentation comment.\nDid you mean to use a multiline comment ( /* ... */ ) instead?", (Object)warnings);
    }

    @Test
    void writeIdlAsProtocol() throws Exception {
        String idl = "src/test/idl/protocol.avdl";
        String protocol = "src/test/idl/protocol.avpr";
        String outfile = "target/test-protocol.avpr";
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        List<String> arglist = Arrays.asList(idl, outfile);
        new IdlTool().run(null, null, new PrintStream(buffer), arglist);
        Assertions.assertEquals((Object)this.readFileAsString(protocol), (Object)this.readFileAsString(outfile));
        String warnings = this.readPrintStreamBuffer(buffer);
        Assertions.assertEquals((Object)"Warning: Line 1, char 1: Ignoring out-of-place documentation comment.\nDid you mean to use a multiline comment ( /* ... */ ) instead?", (Object)warnings);
    }

    @Test
    public void testWriteIdlAsProtocolUsingJavaCC() throws Exception {
        String idl = "src/test/idl/protocol.avdl";
        String protocol = "src/test/idl/protocol.avpr";
        String outfile = "target/test-protocol.avpr";
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        List<String> arglist = Arrays.asList("--useJavaCC", idl, outfile);
        new IdlTool().run(null, null, new PrintStream(buffer), arglist);
        Assertions.assertEquals((Object)this.readFileAsString(protocol), (Object)this.readFileAsString(outfile));
        String warnings = this.readPrintStreamBuffer(buffer);
        Assertions.assertEquals((Object)"Warning: Found documentation comment at line 19, column 1. Ignoring previous one at line 1, column 1: \"Licensed to the Apache Software Foundation (ASF) under one\nor more contributor license agreements.  See the NOTICE file\ndistributed with this work for additional information\nregarding copyright ownership.  The ASF licenses this file\nto you under the Apache License, Version 2.0 (the\n\"License\"); you may not use this file except in compliance\nwith the License.  You may obtain a copy of the License at\n\n    https://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\"\nDid you mean to use a multiline comment ( /* ... */ ) instead?", (Object)warnings);
    }

    private String readFileAsString(String filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private String readPrintStreamBuffer(ByteArrayOutputStream buffer) {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buffer.toByteArray()), Charset.defaultCharset()));
        return reader.lines().collect(Collectors.joining("\n"));
    }
}

