/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.tool.CreateRandomFileTool;
import org.apache.avro.util.RandomData;
import org.apache.trevni.TestUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestCreateRandomFileTool {
    private static final String COUNT = System.getProperty("test.count", "200");
    @TempDir
    private Path dataDir;
    private static final File SCHEMA_FILE = new File("../../../share/test/schemas/weather.avsc");
    private final Schema.Parser schemaParser = new Schema.Parser();
    private static final long SEED = System.currentTimeMillis();
    private ByteArrayOutputStream out;
    private ByteArrayOutputStream err;

    @BeforeEach
    public void before() {
        this.out = new ByteArrayOutputStream();
        this.err = new ByteArrayOutputStream();
    }

    @AfterEach
    public void after() throws Exception {
        this.out.close();
        this.err.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(List<String> args) throws Exception {
        PrintStream output = new PrintStream(this.out);
        PrintStream saveOut = System.out;
        PrintStream error = new PrintStream(this.err);
        PrintStream saveErr = System.err;
        try {
            System.setOut(output);
            System.setErr(error);
            int n = new CreateRandomFileTool().run(null, output, error, args);
            return n;
        }
        finally {
            System.setOut(saveOut);
            System.setErr(saveErr);
        }
    }

    private void check(String ... extraArgs) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        File outFile = this.dataDir.resolve("random.avro").toFile();
        args.addAll(Arrays.asList(outFile.toString(), "--count", COUNT, "--schema-file", SCHEMA_FILE.toString(), "--seed", Long.toString(SEED)));
        args.addAll(Arrays.asList(extraArgs));
        this.run(args);
        DataFileReader reader = new DataFileReader(outFile, (DatumReader)new GenericDatumReader());
        Iterator found = reader.iterator();
        for (Object expected : new RandomData(this.schemaParser.parse(SCHEMA_FILE), Integer.parseInt(COUNT), SEED)) {
            Assertions.assertEquals(expected, found.next());
        }
        reader.close();
    }

    private void checkMissingCount(String ... extraArgs) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        File outFile = this.dataDir.resolve("random.avro").toFile();
        args.addAll(Arrays.asList(outFile.toString(), "--schema-file", SCHEMA_FILE.toString(), "--seed", Long.toString(SEED)));
        args.addAll(Arrays.asList(extraArgs));
        this.run(args);
        Assertions.assertTrue((boolean)this.err.toString().contains("Need count (--count)"));
    }

    @Test
    void simple() throws Exception {
        this.check(new String[0]);
    }

    @Test
    void codec() throws Exception {
        this.check("--codec", "snappy");
    }

    @Test
    void missingCountParameter() throws Exception {
        this.checkMissingCount(new String[0]);
    }

    @Test
    void stdOut() throws Exception {
        TestUtil.resetRandomSeed();
        this.run(Arrays.asList("-", "--count", COUNT, "--schema-file", SCHEMA_FILE.toString(), "--seed", Long.toString(SEED)));
        byte[] file = this.out.toByteArray();
        DataFileStream reader = new DataFileStream((InputStream)new ByteArrayInputStream(file), (DatumReader)new GenericDatumReader());
        Iterator found = reader.iterator();
        for (Object expected : new RandomData(this.schemaParser.parse(SCHEMA_FILE), Integer.parseInt(COUNT), SEED)) {
            Assertions.assertEquals(expected, found.next());
        }
        reader.close();
    }

    @Test
    void defaultCodec() throws Exception {
        this.run(Collections.emptyList());
        Assertions.assertTrue((boolean)this.err.toString().contains("Compression codec (default: deflate)"));
    }
}

