/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.ConcatTool;
import org.apache.avro.util.Utf8;
import org.junit.Rule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.rules.TestName;

public class TestConcatTool {
    private static final int ROWS_IN_INPUT_FILES = 100000;
    private static final CodecFactory DEFLATE = CodecFactory.deflateCodec((int)9);
    @Rule
    public TestName name = new TestName();
    @TempDir
    public File INPUT_DIR;
    @TempDir
    public File OUTPUT_DIR;

    private Object aDatum(Schema.Type ofType, int forRow) {
        switch (ofType) {
            case STRING: {
                return String.valueOf(forRow % 100);
            }
            case INT: {
                return forRow;
            }
        }
        throw new AssertionError((Object)"I can't generate data for this type");
    }

    private File generateData(String file, Schema.Type type, Map<String, String> metadata, CodecFactory codec) throws Exception {
        File inputFile = new File(this.INPUT_DIR, file);
        Schema schema = Schema.create((Schema.Type)type);
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            for (Map.Entry<String, String> metadatum : metadata.entrySet()) {
                writer.setMeta(metadatum.getKey(), metadatum.getValue());
            }
            writer.setCodec(codec);
            writer.create(schema, inputFile);
            for (int i = 0; i < 100000; ++i) {
                writer.append(this.aDatum(type, i));
            }
        }
        return inputFile;
    }

    private CodecFactory getCodec(File output) throws Exception {
        try (DataFileStream reader = new DataFileStream((InputStream)new FileInputStream(output), (DatumReader)new GenericDatumReader());){
            String codec = reader.getMetaString("avro.codec");
            CodecFactory codecFactory = codec == null ? CodecFactory.nullCodec() : CodecFactory.fromString((String)codec);
            return codecFactory;
        }
    }

    private int numRowsInFile(File output) throws Exception {
        int rowcount = 0;
        try (DataFileStream reader = new DataFileStream((InputStream)new FileInputStream(output), (DatumReader)new GenericDatumReader());){
            for (Utf8 ignored : reader) {
                ++rowcount;
            }
        }
        return rowcount;
    }

    @Test
    void dirConcat() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (int i = 0; i < 3; ++i) {
            this.generateData(this.name.getMethodName() + "-" + i + ".avro", Schema.Type.STRING, metadata, DEFLATE);
        }
        File output = new File(this.OUTPUT_DIR, this.name.getMethodName() + ".avro");
        List<String> args = Arrays.asList(this.INPUT_DIR.getAbsolutePath(), output.getAbsolutePath());
        int returnCode = new ConcatTool().run(System.in, System.out, System.err, args);
        Assertions.assertEquals((int)0, (int)returnCode);
        Assertions.assertEquals((int)300000, (int)this.numRowsInFile(output));
    }

    @Test
    void globPatternConcat() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (int i = 0; i < 3; ++i) {
            this.generateData(this.name.getMethodName() + "-" + i + ".avro", Schema.Type.STRING, metadata, DEFLATE);
        }
        File output = new File(this.OUTPUT_DIR, this.name.getMethodName() + ".avro");
        List<String> args = Arrays.asList(new File(this.INPUT_DIR, "/*").getAbsolutePath(), output.getAbsolutePath());
        int returnCode = new ConcatTool().run(System.in, System.out, System.err, args);
        Assertions.assertEquals((int)0, (int)returnCode);
        Assertions.assertEquals((int)300000, (int)this.numRowsInFile(output));
    }

    @Test
    void fileDoesNotExist() throws Exception {
        Assertions.assertThrows(FileNotFoundException.class, () -> {
            File output = new File(this.INPUT_DIR, this.name.getMethodName() + ".avro");
            List<String> args = Arrays.asList(new File(this.INPUT_DIR, "/doNotExist").getAbsolutePath(), output.getAbsolutePath());
            new ConcatTool().run(System.in, System.out, System.err, args);
        });
    }

    @Test
    void concat() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("myMetaKey", "myMetaValue");
        File input1 = this.generateData(this.name.getMethodName() + "-1.avro", Schema.Type.STRING, metadata, DEFLATE);
        File input2 = this.generateData(this.name.getMethodName() + "-2.avro", Schema.Type.STRING, metadata, DEFLATE);
        File input3 = this.generateData(this.name.getMethodName() + "-3.avro", Schema.Type.STRING, metadata, DEFLATE);
        File output = new File(this.OUTPUT_DIR, this.name.getMethodName() + ".avro");
        List<String> args = Arrays.asList(input1.getAbsolutePath(), input2.getAbsolutePath(), input3.getAbsolutePath(), output.getAbsolutePath());
        int returnCode = new ConcatTool().run(System.in, System.out, System.err, args);
        Assertions.assertEquals((int)0, (int)returnCode);
        Assertions.assertEquals((int)300000, (int)this.numRowsInFile(output));
        Assertions.assertEquals(this.getCodec(input1).getClass(), this.getCodec(output).getClass());
    }

    @Test
    void differentSchemasFail() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("myMetaKey", "myMetaValue");
        File input1 = this.generateData(this.name.getMethodName() + "-1.avro", Schema.Type.STRING, metadata, DEFLATE);
        File input2 = this.generateData(this.name.getMethodName() + "-2.avro", Schema.Type.INT, metadata, DEFLATE);
        File output = new File(this.OUTPUT_DIR, this.name.getMethodName() + ".avro");
        List<String> args = Arrays.asList(input1.getAbsolutePath(), input2.getAbsolutePath(), output.getAbsolutePath());
        int returnCode = new ConcatTool().run(System.in, System.out, System.err, args);
        Assertions.assertEquals((int)1, (int)returnCode);
    }

    @Test
    void differentMetadataFail() throws Exception {
        HashMap<String, String> metadata1 = new HashMap<String, String>();
        metadata1.put("myMetaKey", "myMetaValue");
        HashMap<String, String> metadata2 = new HashMap<String, String>();
        metadata2.put("myOtherMetaKey", "myOtherMetaValue");
        File input1 = this.generateData(this.name.getMethodName() + "-1.avro", Schema.Type.STRING, metadata1, DEFLATE);
        File input2 = this.generateData(this.name.getMethodName() + "-2.avro", Schema.Type.STRING, metadata2, DEFLATE);
        File output = new File(this.OUTPUT_DIR, this.name.getMethodName() + ".avro");
        List<String> args = Arrays.asList(input1.getAbsolutePath(), input2.getAbsolutePath(), output.getAbsolutePath());
        int returnCode = new ConcatTool().run(System.in, System.out, System.err, args);
        Assertions.assertEquals((int)2, (int)returnCode);
    }

    @Test
    void differentCodecFail() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("myMetaKey", "myMetaValue");
        File input1 = this.generateData(this.name.getMethodName() + "-1.avro", Schema.Type.STRING, metadata, DEFLATE);
        File input2 = this.generateData(this.name.getMethodName() + "-2.avro", Schema.Type.STRING, metadata, CodecFactory.nullCodec());
        File output = new File(this.OUTPUT_DIR, this.name.getMethodName() + ".avro");
        List<String> args = Arrays.asList(input1.getAbsolutePath(), input2.getAbsolutePath(), output.getAbsolutePath());
        int returnCode = new ConcatTool().run(System.in, System.out, System.err, args);
        Assertions.assertEquals((int)3, (int)returnCode);
    }

    @Test
    void helpfulMessageWhenNoArgsGiven() throws Exception {
        int returnCode;
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);){
            try (PrintStream out = new PrintStream(buffer);){
                returnCode = new ConcatTool().run(System.in, out, System.err, Collections.emptyList());
            }
            Assertions.assertTrue((buffer.toString().trim().length() > 200 ? 1 : 0) != 0, (String)"should have lots of help");
        }
        Assertions.assertEquals((int)0, (int)returnCode);
    }
}

