/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.protobuf;

import com.google.protobuf.Timestamp;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;

public class ProtoConversions {
    private static final int THOUSAND = 1000;
    private static final int MILLION = 1000000;
    private static final int BILLION = 1000000000;
    static final long SECONDS_LOWERLIMIT = -62135596800L;
    static final long SECONDS_UPPERLIMIT = 253402300799L;
    private static final int NANOSECONDS_LOWERLIMIT = 0;
    private static final int NANOSECONDS_UPPERLIMIT = 999999999;

    private static long toLong(Timestamp value, TimestampPrecise precise) {
        long rv = 0L;
        switch (precise) {
            case Millis: {
                rv = value.getSeconds() * 1000L + (long)(value.getNanos() / 1000000);
                break;
            }
            case Micros: {
                rv = value.getSeconds() * 1000000L + (long)(value.getNanos() / 1000);
            }
        }
        return rv;
    }

    private static Timestamp fromLong(Long elapsedSinceEpoch, TimestampPrecise precise) throws IllegalArgumentException {
        long seconds;
        int nanos = switch (precise) {
            case TimestampPrecise.Millis -> {
                seconds = Math.floorDiv((long)elapsedSinceEpoch, 1000L);
                yield (int)Math.floorMod((long)elapsedSinceEpoch, 1000L) * 1000000;
            }
            case TimestampPrecise.Micros -> {
                seconds = Math.floorDiv((long)elapsedSinceEpoch, 1000000L);
                yield (int)Math.floorMod((long)elapsedSinceEpoch, 1000000L) * 1000;
            }
            case TimestampPrecise.Nanos -> {
                seconds = Math.floorDiv((long)elapsedSinceEpoch, 1000000000L);
                yield (int)Math.floorMod((long)elapsedSinceEpoch, 1000000000L);
            }
            default -> throw new IllegalArgumentException("Unknown precision: " + precise);
        };
        if (seconds < -62135596800L || seconds > 253402300799L) {
            throw new IllegalArgumentException("given seconds is out of range");
        }
        if (nanos < 0 || nanos > 999999999) {
            throw new IllegalArgumentException("given nanos is out of range");
        }
        return Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
    }

    private static enum TimestampPrecise {
        Millis,
        Micros,
        Nanos;

    }

    public static class TimestampNanosConversion
    extends Conversion<Timestamp> {
        public Class<Timestamp> getConvertedType() {
            return Timestamp.class;
        }

        public String getLogicalTypeName() {
            return "timestamp-nanos";
        }

        public Timestamp fromLong(Long nanosFromEpoch, Schema schema, LogicalType type) throws IllegalArgumentException {
            return ProtoConversions.fromLong(nanosFromEpoch, TimestampPrecise.Nanos);
        }

        public Long toLong(Timestamp value, Schema schema, LogicalType type) {
            return ProtoConversions.toLong(value, TimestampPrecise.Nanos);
        }

        public Schema getRecommendedSchema() {
            return LogicalTypes.timestampNanos().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        }
    }

    public static class TimestampMicrosConversion
    extends Conversion<Timestamp> {
        public Class<Timestamp> getConvertedType() {
            return Timestamp.class;
        }

        public String getLogicalTypeName() {
            return "timestamp-micros";
        }

        public Timestamp fromLong(Long microsFromEpoch, Schema schema, LogicalType type) throws IllegalArgumentException {
            return ProtoConversions.fromLong(microsFromEpoch, TimestampPrecise.Micros);
        }

        public Long toLong(Timestamp value, Schema schema, LogicalType type) {
            return ProtoConversions.toLong(value, TimestampPrecise.Micros);
        }

        public Schema getRecommendedSchema() {
            return LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        }
    }

    public static class TimestampMillisConversion
    extends Conversion<Timestamp> {
        public Class<Timestamp> getConvertedType() {
            return Timestamp.class;
        }

        public String getLogicalTypeName() {
            return "timestamp-millis";
        }

        public Timestamp fromLong(Long millisFromEpoch, Schema schema, LogicalType type) throws IllegalArgumentException {
            return ProtoConversions.fromLong(millisFromEpoch, TimestampPrecise.Millis);
        }

        public Long toLong(Timestamp value, Schema schema, LogicalType type) {
            return ProtoConversions.toLong(value, TimestampPrecise.Millis);
        }

        public Schema getRecommendedSchema() {
            return LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        }
    }
}

