/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.protobuf.ProtoConversions;
import org.apache.avro.protobuf.ProtobufData;
import org.apache.avro.protobuf.ProtobufDatumReader;
import org.apache.avro.protobuf.ProtobufDatumWriter;
import org.apache.avro.protobuf.multiplefiles.Foo;
import org.apache.avro.protobuf.multiplefiles.M;
import org.apache.avro.protobuf.noopt.Test;
import org.apache.avro.specific.SpecificData;
import org.apache.commons.compress.utils.Lists;
import org.junit.jupiter.api.Assertions;

public class TestProtobuf {
    @org.junit.jupiter.api.Test
    void message() throws Exception {
        System.out.println(ProtobufData.get().getSchema(Test.Foo.class).toString(true));
        Test.Foo.Builder builder = Test.Foo.newBuilder();
        builder.setInt32(0);
        builder.setInt64(2L);
        builder.setUint32(3);
        builder.setUint64(4L);
        builder.setSint32(5);
        builder.setSint64(6L);
        builder.setFixed32(7);
        builder.setFixed64(8L);
        builder.setSfixed32(9);
        builder.setSfixed64(10L);
        builder.setFloat(1.0f);
        builder.setDouble(2.0);
        builder.setBool(true);
        builder.setString("foo");
        builder.setBytes(ByteString.copyFromUtf8((String)"bar"));
        builder.setEnum(Test.A.X);
        builder.addIntArray(27);
        builder.addSyms(Test.A.Y);
        Test.Foo fooInner = builder.build();
        Test.Foo fooInArray = builder.build();
        builder = Test.Foo.newBuilder(fooInArray);
        builder.addFooArray(fooInArray);
        Timestamp ts = Timestamp.newBuilder().setSeconds(1L).setNanos(2).build();
        builder.setTimestamp(ts);
        builder = Test.Foo.newBuilder(fooInner);
        builder.setFoo(fooInner);
        Test.Foo foo = builder.build();
        System.out.println(foo);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ProtobufDatumWriter w = new ProtobufDatumWriter(Test.Foo.class);
        BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)bao, null);
        w.write((Object)foo, (Encoder)e);
        e.flush();
        Object o = new ProtobufDatumReader(Test.Foo.class).read(null, (Decoder)DecoderFactory.get().binaryDecoder((InputStream)new ByteArrayInputStream(bao.toByteArray()), null));
        Assertions.assertEquals((Object)foo, (Object)o);
    }

    @org.junit.jupiter.api.Test
    void messageWithEmptyArray() throws Exception {
        Test.Foo foo = Test.Foo.newBuilder().setInt32(5).setBool(true).build();
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ProtobufDatumWriter w = new ProtobufDatumWriter(Test.Foo.class);
        BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)bao, null);
        w.write((Object)foo, (Encoder)e);
        e.flush();
        Test.Foo o = (Test.Foo)new ProtobufDatumReader(Test.Foo.class).read(null, (Decoder)DecoderFactory.get().binaryDecoder((InputStream)new ByteArrayInputStream(bao.toByteArray()), null));
        Assertions.assertEquals((int)foo.getInt32(), (int)o.getInt32());
        Assertions.assertEquals((Object)foo.getBool(), (Object)o.getBool());
        Assertions.assertEquals((int)0, (int)o.getFooArrayCount());
    }

    @org.junit.jupiter.api.Test
    void emptyArray() throws Exception {
        Schema s = ProtobufData.get().getSchema(Test.Foo.class);
        Assertions.assertEquals((Object)s.getField("fooArray").defaultVal(), (Object)Lists.newArrayList());
    }

    @org.junit.jupiter.api.Test
    void nestedEnum() throws Exception {
        Schema s = ProtobufData.get().getSchema(Test.M.N.class);
        Assertions.assertEquals((Object)Test.M.N.class.getName(), (Object)SpecificData.get().getClass(s).getName());
    }

    @org.junit.jupiter.api.Test
    void nestedClassNamespace() throws Exception {
        Schema s = ProtobufData.get().getSchema(Test.Foo.class);
        Assertions.assertEquals((Object)Test.class.getName(), (Object)s.getNamespace());
    }

    @org.junit.jupiter.api.Test
    void classNamespaceInMultipleFiles() throws Exception {
        Schema fooSchema = ProtobufData.get().getSchema(Foo.class);
        Assertions.assertEquals((Object)Foo.class.getPackage().getName(), (Object)fooSchema.getNamespace());
        Schema nSchema = ProtobufData.get().getSchema(M.N.class);
        Assertions.assertEquals((Object)M.class.getName(), (Object)nSchema.getNamespace());
    }

    @org.junit.jupiter.api.Test
    void getNonRepeatedSchemaWithLogicalType() throws Exception {
        ProtoConversions.TimestampMillisConversion conversion = new ProtoConversions.TimestampMillisConversion();
        ProtobufData instance1 = new ProtobufData();
        Schema s1 = instance1.getSchema(Timestamp.class);
        Assertions.assertNotEquals((Object)conversion.getRecommendedSchema(), (Object)s1);
        ProtobufData instance2 = new ProtobufData();
        instance2.addLogicalTypeConversion((Conversion)conversion);
        Schema s2 = instance2.getSchema(Timestamp.class);
        Assertions.assertEquals((Object)conversion.getRecommendedSchema(), (Object)s2);
    }
}

