/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.protobuf;

import com.google.protobuf.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.protobuf.ProtoConversions;
import org.apache.avro.reflect.ReflectData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestProtoConversions {
    private static Schema TIMESTAMP_MILLIS_SCHEMA;
    private static Schema TIMESTAMP_MICROS_SCHEMA;
    private static Calendar Jan_2_1900_3_4_5_678;
    private static Calendar May_28_2015_21_46_53_221;

    @BeforeAll
    public static void createSchemas() {
        TIMESTAMP_MILLIS_SCHEMA = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        TIMESTAMP_MICROS_SCHEMA = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    }

    @Test
    void timestampMillisConversion() throws Exception {
        ProtoConversions.TimestampMillisConversion conversion = new ProtoConversions.TimestampMillisConversion();
        Timestamp May_28_2015_21_46_53_221_ts = Timestamp.newBuilder().setSeconds(1432849613L).setNanos(221000000).build();
        Timestamp Jan_2_1900_3_4_5_678_ts = Timestamp.newBuilder().setSeconds(-2208891355L).setNanos(678000000).build();
        long instant = May_28_2015_21_46_53_221.getTimeInMillis();
        Timestamp tsFromInstant = conversion.fromLong(Long.valueOf(instant), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis());
        long roundTrip = conversion.toLong(tsFromInstant, TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis());
        Assertions.assertEquals((long)instant, (long)roundTrip, (String)"Round-trip conversion should work");
        Assertions.assertEquals((Object)May_28_2015_21_46_53_221_ts, (Object)conversion.fromLong(Long.valueOf(instant), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"Known timestamp should be correct");
        Assertions.assertEquals((long)instant, (long)conversion.toLong(May_28_2015_21_46_53_221_ts, TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"Known timestamp should be correct");
        instant = Jan_2_1900_3_4_5_678.getTimeInMillis();
        tsFromInstant = conversion.fromLong(Long.valueOf(instant), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis());
        roundTrip = conversion.toLong(tsFromInstant, TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis());
        Assertions.assertEquals((long)instant, (long)roundTrip, (String)"Round-trip conversion should work");
        Assertions.assertEquals((Object)Jan_2_1900_3_4_5_678_ts, (Object)conversion.fromLong(Long.valueOf(instant), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"Known timestamp should be correct");
        Assertions.assertEquals((long)instant, (long)conversion.toLong(Jan_2_1900_3_4_5_678_ts, TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"Known timestamp should be correct");
    }

    @Test
    void timestampMicrosConversion() {
        ProtoConversions.TimestampMicrosConversion conversion = new ProtoConversions.TimestampMicrosConversion();
        Timestamp May_28_2015_21_46_53_221_843_ts = Timestamp.newBuilder().setSeconds(1432849613L).setNanos(221843000).build();
        Timestamp Jan_2_1900_3_4_5_678_901_ts = Timestamp.newBuilder().setSeconds(-2208891355L).setNanos(678901000).build();
        long instant = May_28_2015_21_46_53_221.getTimeInMillis() * 1000L + 843L;
        Timestamp tsFromInstant = conversion.fromLong(Long.valueOf(instant), TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros());
        long roundTrip = conversion.toLong(tsFromInstant, TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros());
        Assertions.assertEquals((long)instant, (long)roundTrip, (String)"Round-trip conversion should work");
        Assertions.assertEquals((Object)May_28_2015_21_46_53_221_843_ts, (Object)conversion.fromLong(Long.valueOf(instant), TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros()), (String)"Known timestamp should be correct");
        Assertions.assertEquals((long)instant, (long)conversion.toLong(May_28_2015_21_46_53_221_843_ts, TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros()), (String)"Known timestamp should be correct");
        instant = Jan_2_1900_3_4_5_678.getTimeInMillis() * 1000L + 901L;
        tsFromInstant = conversion.fromLong(Long.valueOf(instant), TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros());
        roundTrip = conversion.toLong(tsFromInstant, TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros());
        Assertions.assertEquals((long)instant, (long)roundTrip, (String)"Round-trip conversion should work");
        Assertions.assertEquals((Object)Jan_2_1900_3_4_5_678_901_ts, (Object)conversion.fromLong(Long.valueOf(instant), TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros()), (String)"Known timestamp should be correct");
        Assertions.assertEquals((long)instant, (long)conversion.toLong(Jan_2_1900_3_4_5_678_901_ts, TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros()), (String)"Known timestamp should be correct");
    }

    @Test
    void timestampMillisConversionSecondsLowerLimit() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ProtoConversions.TimestampMillisConversion conversion = new ProtoConversions.TimestampMillisConversion();
            long exceeded = -62135596801000L;
            conversion.fromLong(Long.valueOf(exceeded), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis());
        });
    }

    @Test
    void timestampMillisConversionSecondsUpperLimit() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ProtoConversions.TimestampMillisConversion conversion = new ProtoConversions.TimestampMillisConversion();
            long exceeded = 253402300800000L;
            conversion.fromLong(Long.valueOf(exceeded), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis());
        });
    }

    @Test
    void timestampMicrosConversionSecondsLowerLimit() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ProtoConversions.TimestampMicrosConversion conversion = new ProtoConversions.TimestampMicrosConversion();
            long exceeded = -62135596801000000L;
            conversion.fromLong(Long.valueOf(exceeded), TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros());
        });
    }

    @Test
    void timestampMicrosConversionSecondsUpperLimit() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ProtoConversions.TimestampMicrosConversion conversion = new ProtoConversions.TimestampMicrosConversion();
            long exceeded = 253402300800000000L;
            conversion.fromLong(Long.valueOf(exceeded), TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros());
        });
    }

    @Test
    void dynamicSchemaWithDateTimeConversion() throws ClassNotFoundException {
        Schema schema = this.getReflectedSchemaByName("com.google.protobuf.Timestamp", (Conversion<?>)new ProtoConversions.TimestampMillisConversion());
        Assertions.assertEquals((Object)TIMESTAMP_MILLIS_SCHEMA, (Object)schema, (String)"Reflected schema should be logicalType timestampMillis");
    }

    @Test
    void dynamicSchemaWithDateTimeMicrosConversion() throws ClassNotFoundException {
        Schema schema = this.getReflectedSchemaByName("com.google.protobuf.Timestamp", (Conversion<?>)new ProtoConversions.TimestampMicrosConversion());
        Assertions.assertEquals((Object)TIMESTAMP_MICROS_SCHEMA, (Object)schema, (String)"Reflected schema should be logicalType timestampMicros");
    }

    private Schema getReflectedSchemaByName(String className, Conversion<?> conversion) throws ClassNotFoundException {
        Class<?> cls = Class.forName(className);
        ReflectData model = new ReflectData();
        model.addLogicalTypeConversion(conversion);
        return model.getSchema(cls);
    }

    static {
        Jan_2_1900_3_4_5_678 = Calendar.getInstance();
        May_28_2015_21_46_53_221 = Calendar.getInstance();
        May_28_2015_21_46_53_221.setTimeZone(TimeZone.getTimeZone("UTC"));
        May_28_2015_21_46_53_221.set(2015, 4, 28, 21, 46, 53);
        May_28_2015_21_46_53_221.set(14, 221);
        Jan_2_1900_3_4_5_678.setTimeZone(TimeZone.getTimeZone("UTC"));
        Jan_2_1900_3_4_5_678.set(1900, 0, 2, 3, 4, 5);
        Jan_2_1900_3_4_5_678.set(14, 678);
    }
}

