/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.SchemaParseException;
import org.apache.avro.SchemaParser;
import org.apache.avro.mojo.AbstractAvroMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class SchemaMojo
extends AbstractAvroMojo {
    private SchemaParser schemaParser = new SchemaParser();
    private String[] includes = new String[]{"**/*.avsc"};
    private String[] testIncludes = new String[]{"**/*.avsc"};

    @Override
    protected void doCompile(String[] fileNames, File sourceDirectory, File outputDirectory) throws MojoExecutionException {
        List sourceFiles = Arrays.stream(fileNames).map(filename -> new File(sourceDirectory, (String)filename)).collect(Collectors.toList());
        File sourceFileForModificationDetection = sourceFiles.stream().filter(file -> file.lastModified() > 0L).max(Comparator.comparing(File::lastModified)).orElse(null);
        try {
            SchemaParser parser = this.imports == null ? new SchemaParser() : this.schemaParser;
            for (File sourceFile : sourceFiles) {
                parser.parse(sourceFile);
            }
            List schemas = parser.getParsedNamedSchemas();
            this.doCompile(sourceFileForModificationDetection, schemas, outputDirectory);
        }
        catch (IOException | SchemaParseException ex) {
            throw new MojoExecutionException("Error compiling a file in " + sourceDirectory + " to " + outputDirectory, (Exception)ex);
        }
    }

    @Override
    protected String[] getIncludes() {
        return this.includes;
    }

    @Override
    protected String[] getTestIncludes() {
        return this.testIncludes;
    }
}

