/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestFsInput {
    private static File file;
    private static final String FILE_CONTENTS = "abcdefghijklmnopqrstuvwxyz";
    private Configuration conf;
    private FsInput fsInput;
    @TempDir
    public File DIR;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("fs.default.name", "file:///");
        file = new File(this.DIR, "file.txt");
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            out.print(FILE_CONTENTS);
        }
        this.fsInput = new FsInput(new Path(file.getPath()), this.conf);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.fsInput != null) {
            this.fsInput.close();
        }
    }

    @Test
    void configurationConstructor() throws Exception {
        try (FsInput in = new FsInput(new Path(file.getPath()), this.conf);){
            int expectedByteCount = 1;
            byte[] readBytes = new byte[expectedByteCount];
            int actualByteCount = this.fsInput.read(readBytes, 0, expectedByteCount);
            MatcherAssert.assertThat((Object)actualByteCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedByteCount)));
        }
    }

    @Test
    void fileSystemConstructor() throws Exception {
        Path path = new Path(file.getPath());
        FileSystem fs = path.getFileSystem(this.conf);
        try (FsInput in = new FsInput(path, fs);){
            int expectedByteCount = 1;
            byte[] readBytes = new byte[expectedByteCount];
            int actualByteCount = this.fsInput.read(readBytes, 0, expectedByteCount);
            MatcherAssert.assertThat((Object)actualByteCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedByteCount)));
        }
    }

    @Test
    void length() throws IOException {
        Assertions.assertEquals((long)this.fsInput.length(), (long)FILE_CONTENTS.length());
    }

    @Test
    void read() throws Exception {
        byte[] expectedBytes = FILE_CONTENTS.getBytes(StandardCharsets.UTF_8);
        byte[] actualBytes = new byte[expectedBytes.length];
        int actualByteCount = this.fsInput.read(actualBytes, 0, actualBytes.length);
        MatcherAssert.assertThat((Object)actualBytes, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedBytes)));
        MatcherAssert.assertThat((Object)actualByteCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedBytes.length)));
    }

    @Test
    void seek() throws Exception {
        int seekPos = FILE_CONTENTS.length() / 2;
        byte[] fileContentBytes = FILE_CONTENTS.getBytes(StandardCharsets.UTF_8);
        byte expectedByte = fileContentBytes[seekPos];
        this.fsInput.seek((long)seekPos);
        byte[] readBytes = new byte[1];
        this.fsInput.read(readBytes, 0, 1);
        byte actualByte = readBytes[0];
        MatcherAssert.assertThat((Object)actualByte, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedByte)));
    }

    @Test
    void tell() throws Exception {
        long expectedTellPos = FILE_CONTENTS.length() / 2;
        this.fsInput.seek(expectedTellPos);
        long actualTellPos = this.fsInput.tell();
        MatcherAssert.assertThat((Object)actualTellPos, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedTellPos)));
    }
}

