/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.avro.mapred.Pair;
import org.apache.avro.mapred.tether.TetherTask;
import org.apache.avro.mapred.tether.TetherTaskRunner;
import org.apache.avro.util.Utf8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordCountTask
extends TetherTask<Utf8, Pair<Utf8, Long>, Pair<Utf8, Long>> {
    static final Logger LOG = LoggerFactory.getLogger(WordCountTask.class);
    private long sum;

    @Override
    public void map(Utf8 text, TetherTask.Collector<Pair<Utf8, Long>> collector) throws IOException {
        StringTokenizer tokens = new StringTokenizer(text.toString());
        while (tokens.hasMoreTokens()) {
            collector.collect((Pair<Utf8, Long>)new Pair((CharSequence)new Utf8(tokens.nextToken()), Long.valueOf(1L)));
        }
    }

    @Override
    public void reduce(Pair<Utf8, Long> wc, TetherTask.Collector<Pair<Utf8, Long>> c) {
        this.sum += ((Long)wc.value()).longValue();
    }

    @Override
    public void reduceFlush(Pair<Utf8, Long> wc, TetherTask.Collector<Pair<Utf8, Long>> c) throws IOException {
        wc.value((Object)this.sum);
        c.collect(wc);
        this.sum = 0L;
    }

    public static void main(String[] args) throws Exception {
        new TetherTaskRunner(new WordCountTask()).join();
        LOG.info("WordCountTask finished");
    }
}

