/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.Pair;
import org.apache.avro.mapred.WordCountUtil;
import org.apache.avro.mapred.tether.TetherJob;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestWordCountTether {
    @TempDir
    public File INPUT_DIR;
    @TempDir
    public File OUTPUT_DIR;

    private void _runjob(String proto) throws Exception {
        String outputPathStr = this.OUTPUT_DIR.getPath();
        File inputPath = new File(this.INPUT_DIR, "lines.avro");
        JobConf job = new JobConf();
        Path outputPath = new Path(outputPathStr);
        outputPath.getFileSystem((Configuration)job).delete(outputPath, true);
        WordCountUtil.writeLinesFile(inputPath);
        File exec = new File(System.getProperty("java.home") + "/bin/java");
        ArrayList<String> execargs = new ArrayList<String>();
        execargs.add("-classpath");
        execargs.add(System.getProperty("java.class.path"));
        execargs.add("org.apache.avro.mapred.tether.WordCountTask");
        FileInputFormat.addInputPaths((JobConf)job, (String)inputPath.toString());
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
        TetherJob.setExecutable((JobConf)job, (File)exec, execargs, (boolean)false);
        Schema outscheme = new Pair((CharSequence)new Utf8(""), Long.valueOf(0L)).getSchema();
        AvroJob.setInputSchema((JobConf)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        job.set("avro.output.schema", outscheme.toString());
        TetherJob.setProtocol((JobConf)job, (String)proto);
        TetherJob.runJob((JobConf)job);
        SpecificDatumReader reader = new SpecificDatumReader();
        DataFileStream counts = new DataFileStream((InputStream)new BufferedInputStream(new FileInputStream(outputPath + "/part-00000.avro")), (DatumReader)reader);
        int numWords = 0;
        for (Pair wc : counts) {
            Assertions.assertEquals((Long)WordCountUtil.COUNTS.get(((Utf8)wc.key()).toString()), (Long)((Long)wc.value()), (String)((Utf8)wc.key()).toString());
            ++numWords;
        }
        counts.close();
        Assertions.assertEquals((int)WordCountUtil.COUNTS.size(), (int)numWords);
    }

    @Test
    void job() throws Exception {
        this._runjob("sasl");
    }

    @Test
    void htp() throws Exception {
        this._runjob("http");
    }
}

