/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroOutputFormat;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestGenericJob {
    @TempDir
    public File DIR;

    private static Schema createSchema() {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("Optional", TestGenericJob.createArraySchema(), "", new ArrayList()));
        Schema recordSchema = Schema.createRecord((String)"Container", (String)"", (String)"org.apache.avro.mapred", (boolean)false);
        recordSchema.setFields(fields);
        return recordSchema;
    }

    private static Schema createArraySchema() {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (int i = 0; i < 5; ++i) {
            schemas.add(TestGenericJob.createInnerSchema("optional_field_" + i));
        }
        Schema unionSchema = Schema.createUnion(schemas);
        return Schema.createArray((Schema)unionSchema);
    }

    private static Schema createInnerSchema(String name) {
        Schema innerrecord = Schema.createRecord((String)name, (String)"", (String)"", (boolean)false);
        innerrecord.setFields(Collections.singletonList(new Schema.Field(name, Schema.create((Schema.Type)Schema.Type.LONG), "", (Object)0L)));
        return innerrecord;
    }

    @BeforeEach
    public void setup() throws IOException {
        String dir = this.DIR.getPath();
        File infile = new File(dir + "/in");
        RandomAccessFile file = new RandomAccessFile(infile, "rw");
        file.writeChars("aa bb cc\ndd ee ff\n");
        file.close();
    }

    @Test
    void job() throws Exception {
        JobConf job = new JobConf();
        Path outputPath = new Path(this.DIR.getPath() + "/out");
        outputPath.getFileSystem((Configuration)job).delete(outputPath);
        job.setInputFormat(TextInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)job, (String)(this.DIR.getPath() + "/in"));
        job.setMapperClass(AvroTestConverter.class);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
        System.out.println(TestGenericJob.createSchema());
        AvroJob.setOutputSchema((JobConf)job, (Schema)Pair.getPairSchema((Schema)Schema.create((Schema.Type)Schema.Type.LONG), (Schema)TestGenericJob.createSchema()));
        job.setOutputFormat(AvroOutputFormat.class);
        JobClient.runJob((JobConf)job);
    }

    static class AvroTestConverter
    extends MapReduceBase
    implements Mapper<LongWritable, Text, AvroWrapper<Pair<Long, GenericData.Record>>, NullWritable> {
        AvroTestConverter() {
        }

        public void map(LongWritable key, Text value, OutputCollector<AvroWrapper<Pair<Long, GenericData.Record>>, NullWritable> out, Reporter reporter) throws IOException {
            GenericData.Record optional_entry = new GenericData.Record(TestGenericJob.createInnerSchema("optional_field_1"));
            optional_entry.put("optional_field_1", (Object)0L);
            GenericData.Array array = new GenericData.Array(1, TestGenericJob.createArraySchema());
            array.add((Object)optional_entry);
            GenericData.Record container = new GenericData.Record(TestGenericJob.createSchema());
            container.put("Optional", (Object)array);
            out.collect((Object)new AvroWrapper((Object)new Pair(Long.valueOf(key.get()), (GenericContainer)container)), (Object)NullWritable.get());
        }
    }
}

