/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.File;
import org.apache.avro.mapred.AvroAsTextInputFormat;
import org.apache.avro.mapred.AvroTextOutputFormat;
import org.apache.avro.mapred.WordCountUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestAvroTextSort {
    @TempDir
    public File INPUT_DIR;
    @TempDir
    public File OUTPUT_DIR;

    @Test
    void sort() throws Exception {
        JobConf job = new JobConf();
        String inputPath = this.INPUT_DIR.getPath();
        Path outputPath = new Path(this.OUTPUT_DIR.getPath());
        outputPath.getFileSystem((Configuration)job).delete(outputPath, true);
        WordCountUtil.writeLinesBytesFile(inputPath);
        job.setInputFormat(AvroAsTextInputFormat.class);
        job.setOutputFormat(AvroTextOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
        JobClient.runJob((JobConf)job);
        WordCountUtil.validateSortedFile(outputPath.toString() + "/part-00000.avro");
    }
}

