/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.util;

import org.apache.avro.hadoop.util.AvroCharSequenceComparator;
import org.apache.avro.util.Utf8;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAvroCharSequenceComparator {
    private AvroCharSequenceComparator<CharSequence> mComparator;

    @BeforeEach
    public void setup() {
        this.mComparator = new AvroCharSequenceComparator();
    }

    @Test
    void compareString() {
        Assertions.assertEquals((int)0, (int)this.mComparator.compare((Object)"", (Object)""));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)"", (Object)"a"), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)"a", (Object)""), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assertions.assertEquals((int)0, (int)this.mComparator.compare((Object)"a", (Object)"a"));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)"a", (Object)"b"), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)"b", (Object)"a"), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assertions.assertEquals((int)0, (int)this.mComparator.compare((Object)"ab", (Object)"ab"));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)"a", (Object)"aa"), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)"aa", (Object)"a"), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)"abc", (Object)"abcdef"), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)"abcdef", (Object)"abc"), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    void compareUtf8() {
        Assertions.assertEquals((int)0, (int)this.mComparator.compare((Object)new Utf8(""), (Object)new Utf8("")));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8(""), (Object)new Utf8("a")), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("a"), (Object)new Utf8("")), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assertions.assertEquals((int)0, (int)this.mComparator.compare((Object)new Utf8("a"), (Object)new Utf8("a")));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("a"), (Object)new Utf8("b")), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("b"), (Object)new Utf8("a")), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assertions.assertEquals((int)0, (int)this.mComparator.compare((Object)new Utf8("ab"), (Object)new Utf8("ab")));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("a"), (Object)new Utf8("aa")), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("aa"), (Object)new Utf8("a")), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("abc"), (Object)new Utf8("abcdef")), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("abcdef"), (Object)new Utf8("abc")), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    void compareUtf8ToString() {
        Assertions.assertEquals((int)0, (int)this.mComparator.compare((Object)new Utf8(""), (Object)""));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8(""), (Object)"a"), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("a"), (Object)""), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assertions.assertEquals((int)0, (int)this.mComparator.compare((Object)new Utf8("a"), (Object)"a"));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("a"), (Object)"b"), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("b"), (Object)"a"), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assertions.assertEquals((int)0, (int)this.mComparator.compare((Object)new Utf8("ab"), (Object)"ab"));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("a"), (Object)"aa"), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("aa"), (Object)"a"), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("abc"), (Object)"abcdef"), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)this.mComparator.compare((Object)new Utf8("abcdef"), (Object)"abc"), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }
}

