/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.hadoop.io.AvroDeserializer;
import org.apache.avro.hadoop.io.AvroKeyDeserializer;
import org.apache.avro.hadoop.io.AvroSerialization;
import org.apache.avro.hadoop.io.AvroSerializer;
import org.apache.avro.hadoop.io.AvroValueDeserializer;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAvroSerialization {
    @Test
    void accept() {
        AvroSerialization serialization = new AvroSerialization();
        Assertions.assertTrue((boolean)serialization.accept(AvroKey.class));
        Assertions.assertTrue((boolean)serialization.accept(AvroValue.class));
        Assertions.assertFalse((boolean)serialization.accept(AvroWrapper.class));
        Assertions.assertFalse((boolean)serialization.accept(String.class));
    }

    @Test
    void getSerializerForKey() throws IOException {
        Schema writerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Job job = Job.getInstance();
        AvroJob.setMapOutputKeySchema((Job)job, (Schema)writerSchema);
        AvroSerialization serialization = (AvroSerialization)ReflectionUtils.newInstance(AvroSerialization.class, (Configuration)job.getConfiguration());
        Serializer serializer = serialization.getSerializer(AvroKey.class);
        Assertions.assertTrue((boolean)(serializer instanceof AvroSerializer));
        AvroSerializer avroSerializer = (AvroSerializer)serializer;
        Assertions.assertEquals((Object)writerSchema, (Object)avroSerializer.getWriterSchema());
    }

    @Test
    void getSerializerForValue() throws IOException {
        Schema writerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Job job = Job.getInstance();
        AvroJob.setMapOutputValueSchema((Job)job, (Schema)writerSchema);
        AvroSerialization serialization = (AvroSerialization)ReflectionUtils.newInstance(AvroSerialization.class, (Configuration)job.getConfiguration());
        Serializer serializer = serialization.getSerializer(AvroValue.class);
        Assertions.assertTrue((boolean)(serializer instanceof AvroSerializer));
        AvroSerializer avroSerializer = (AvroSerializer)serializer;
        Assertions.assertEquals((Object)writerSchema, (Object)avroSerializer.getWriterSchema());
    }

    @Test
    void getDeserializerForKey() throws IOException {
        Schema readerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Job job = Job.getInstance();
        AvroJob.setMapOutputKeySchema((Job)job, (Schema)readerSchema);
        AvroSerialization serialization = (AvroSerialization)ReflectionUtils.newInstance(AvroSerialization.class, (Configuration)job.getConfiguration());
        Deserializer deserializer = serialization.getDeserializer(AvroKey.class);
        Assertions.assertTrue((boolean)(deserializer instanceof AvroKeyDeserializer));
        AvroKeyDeserializer avroDeserializer = (AvroKeyDeserializer)deserializer;
        Assertions.assertEquals((Object)readerSchema, (Object)avroDeserializer.getReaderSchema());
    }

    @Test
    void getDeserializerForValue() throws IOException {
        Schema readerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Job job = Job.getInstance();
        AvroJob.setMapOutputValueSchema((Job)job, (Schema)readerSchema);
        AvroSerialization serialization = (AvroSerialization)ReflectionUtils.newInstance(AvroSerialization.class, (Configuration)job.getConfiguration());
        Deserializer deserializer = serialization.getDeserializer(AvroValue.class);
        Assertions.assertTrue((boolean)(deserializer instanceof AvroValueDeserializer));
        AvroValueDeserializer avroDeserializer = (AvroValueDeserializer)deserializer;
        Assertions.assertEquals((Object)readerSchema, (Object)avroDeserializer.getReaderSchema());
    }

    @Test
    void classPath() throws Exception {
        Configuration conf = new Configuration();
        ClassLoader loader = conf.getClass().getClassLoader();
        AvroSerialization serialization = new AvroSerialization();
        serialization.setConf(conf);
        AvroDeserializer des = (AvroDeserializer)serialization.getDeserializer(AvroKey.class);
        ReflectData data = (ReflectData)((ReflectDatumReader)des.mAvroDatumReader).getData();
        Assertions.assertEquals((Object)loader, (Object)data.getClassLoader());
    }

    private <T, O> O roundTrip(Schema schema, T data, Class<? extends GenericData> modelClass) throws IOException {
        Job job = Job.getInstance();
        AvroJob.setMapOutputKeySchema((Job)job, (Schema)schema);
        if (modelClass != null) {
            AvroJob.setDataModelClass((Job)job, modelClass);
        }
        AvroSerialization serialization = (AvroSerialization)ReflectionUtils.newInstance(AvroSerialization.class, (Configuration)job.getConfiguration());
        Serializer serializer = serialization.getSerializer(AvroKey.class);
        Deserializer deserializer = serialization.getDeserializer(AvroKey.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.open((OutputStream)baos);
        serializer.serialize((Object)new AvroKey(data));
        serializer.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        deserializer.open((InputStream)bais);
        AvroKey result = null;
        result = (AvroKey)deserializer.deserialize(result);
        deserializer.close();
        return (O)result.datum();
    }

    @Test
    void roundTrip() throws Exception {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        Assertions.assertTrue((boolean)(this.roundTrip(schema, "record", null) instanceof String));
        Assertions.assertTrue((boolean)(this.roundTrip(schema, "record", GenericData.class) instanceof Utf8));
    }
}

