/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.io;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.hadoop.io.AvroSequenceFile;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestAvroSequenceFile {
    @TempDir
    public File mTempDir;

    @Test
    void readAvro() throws IOException {
        Path sequenceFilePath = new Path(new File(this.mTempDir, "output.seq").getPath());
        this.writeSequenceFile(sequenceFilePath, AvroKey.class, AvroValue.class, Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.INT), new AvroKey((Object)"one"), new AvroValue((Object)1), new AvroKey((Object)"two"), new AvroValue((Object)2));
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        AvroSequenceFile.Reader.Options options = new AvroSequenceFile.Reader.Options().withFileSystem(fs).withInputPath(sequenceFilePath).withKeySchema(Schema.create((Schema.Type)Schema.Type.STRING)).withValueSchema(Schema.create((Schema.Type)Schema.Type.INT)).withConfiguration(conf);
        try (AvroSequenceFile.Reader reader = new AvroSequenceFile.Reader(options);){
            AvroKey key = new AvroKey();
            AvroValue value = new AvroValue();
            key = (AvroKey)reader.next((Object)key);
            Assertions.assertNotNull((Object)key);
            Assertions.assertEquals((Object)"one", (Object)((CharSequence)key.datum()).toString());
            value = (AvroValue)reader.getCurrentValue((Object)value);
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((int)1, (int)((Integer)value.datum()));
            key = (AvroKey)reader.next((Object)key);
            Assertions.assertNotNull((Object)key);
            Assertions.assertEquals((Object)"two", (Object)((CharSequence)key.datum()).toString());
            value = (AvroValue)reader.getCurrentValue((Object)value);
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((int)2, (int)((Integer)value.datum()));
            Assertions.assertNull((Object)reader.next((Object)key), (String)"Should be no more records.");
        }
    }

    @Test
    void readAvroWithoutReaderSchemas() throws IOException {
        Path sequenceFilePath = new Path(new File(this.mTempDir, "output.seq").getPath());
        this.writeSequenceFile(sequenceFilePath, AvroKey.class, AvroValue.class, Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.INT), new AvroKey((Object)"one"), new AvroValue((Object)1), new AvroKey((Object)"two"), new AvroValue((Object)2));
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        AvroSequenceFile.Reader.Options options = new AvroSequenceFile.Reader.Options().withFileSystem(fs).withInputPath(sequenceFilePath).withConfiguration(conf);
        try (AvroSequenceFile.Reader reader = new AvroSequenceFile.Reader(options);){
            AvroKey key = new AvroKey();
            AvroValue value = new AvroValue();
            key = (AvroKey)reader.next((Object)key);
            Assertions.assertNotNull((Object)key);
            Assertions.assertEquals((Object)"one", (Object)((CharSequence)key.datum()).toString());
            value = (AvroValue)reader.getCurrentValue((Object)value);
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((int)1, (int)((Integer)value.datum()));
            key = (AvroKey)reader.next((Object)key);
            Assertions.assertNotNull((Object)key);
            Assertions.assertEquals((Object)"two", (Object)((CharSequence)key.datum()).toString());
            value = (AvroValue)reader.getCurrentValue((Object)value);
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((int)2, (int)((Integer)value.datum()));
            Assertions.assertNull((Object)reader.next((Object)key), (String)"Should be no more records.");
        }
    }

    @Test
    void readWritables() throws IOException {
        Path sequenceFilePath = new Path(new File(this.mTempDir, "output.seq").getPath());
        this.writeSequenceFile(sequenceFilePath, Text.class, IntWritable.class, null, null, new Text("one"), new IntWritable(1), new Text("two"), new IntWritable(2));
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        AvroSequenceFile.Reader.Options options = new AvroSequenceFile.Reader.Options().withFileSystem(fs).withInputPath(sequenceFilePath).withConfiguration(conf);
        try (AvroSequenceFile.Reader reader = new AvroSequenceFile.Reader(options);){
            Text key = new Text();
            IntWritable value = new IntWritable();
            Assertions.assertTrue((boolean)reader.next((Writable)key));
            Assertions.assertEquals((Object)"one", (Object)key.toString());
            reader.getCurrentValue((Writable)value);
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((int)1, (int)value.get());
            Assertions.assertTrue((boolean)reader.next((Writable)key));
            Assertions.assertEquals((Object)"two", (Object)key.toString());
            reader.getCurrentValue((Writable)value);
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((int)2, (int)value.get());
            Assertions.assertFalse((boolean)reader.next((Writable)key), (String)"Should be no more records.");
        }
    }

    private void writeSequenceFile(Path file, Class<?> keyClass, Class<?> valueClass, Schema keySchema, Schema valueSchema, Object ... records) throws IOException {
        if (0 != records.length % 2) {
            throw new IllegalArgumentException("Expected a value for each key record.");
        }
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        AvroSequenceFile.Writer.Options options = new AvroSequenceFile.Writer.Options().withFileSystem(fs).withConfiguration(conf).withOutputPath(file);
        if (null != keySchema) {
            options.withKeySchema(keySchema);
        } else {
            options.withKeyClass(keyClass);
        }
        if (null != valueSchema) {
            options.withValueSchema(valueSchema);
        } else {
            options.withValueClass(valueClass);
        }
        try (AvroSequenceFile.Writer writer = new AvroSequenceFile.Writer(options);){
            for (int i = 0; i < records.length; i += 2) {
                writer.append(records[i], records[i + 1]);
            }
        }
    }
}

