/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.avro.mapreduce.TextStats;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestWordCount {
    @TempDir
    public File tmpFolder;
    public static final Schema STATS_SCHEMA = new Schema.Parser().parse("{\"name\":\"stats\",\"type\":\"record\",\"fields\":[{\"name\":\"count\",\"type\":\"int\"},{\"name\":\"name\",\"type\":\"string\"}]}");
    private static Schema REFLECT_STATS_SCHEMA = ReflectData.get().getSchema(ReflectStats.class);

    @Test
    void avroGenericOutput() throws Exception {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.txt").toURI().toString())});
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(LineCountMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(GenericStatsReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)STATS_SCHEMA);
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        Path outputPath = new Path(this.tmpFolder.getPath() + "/out-generic");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        FileStatus[] outputFiles = fileSystem.globStatus(outputPath.suffix("/part-*"));
        Assertions.assertEquals((int)1, (int)outputFiles.length);
        DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new GenericDatumReader(STATS_SCHEMA));
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (GenericData.Record record : reader) {
            counts.put(((Utf8)record.get("name")).toString(), (Integer)record.get("count"));
        }
        reader.close();
        Assertions.assertEquals((int)3, (int)((Integer)counts.get("apple")));
        Assertions.assertEquals((int)2, (int)((Integer)counts.get("banana")));
        Assertions.assertEquals((int)1, (int)((Integer)counts.get("carrot")));
    }

    @Test
    void avroSpecificOutput() throws Exception {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.txt").toURI().toString())});
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(LineCountMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(SpecificStatsReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        Path outputPath = new Path(this.tmpFolder.getPath() + "/out-specific");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        FileStatus[] outputFiles = fileSystem.globStatus(outputPath.suffix("/part-*"));
        Assertions.assertEquals((int)1, (int)outputFiles.length);
        DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new SpecificDatumReader());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (TextStats record : reader) {
            counts.put(record.getName().toString(), record.getCount());
        }
        reader.close();
        Assertions.assertEquals((int)3, (int)((Integer)counts.get("apple")));
        Assertions.assertEquals((int)2, (int)((Integer)counts.get("banana")));
        Assertions.assertEquals((int)1, (int)((Integer)counts.get("carrot")));
    }

    @Test
    void avroReflectOutput() throws Exception {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.txt").toURI().toString())});
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(LineCountMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(ReflectStatsReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)REFLECT_STATS_SCHEMA);
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        Path outputPath = new Path(this.tmpFolder.getPath() + "/out-reflect");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        FileStatus[] outputFiles = fileSystem.globStatus(outputPath.suffix("/part-*"));
        Assertions.assertEquals((int)1, (int)outputFiles.length);
        DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new ReflectDatumReader());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (ReflectStats record : reader) {
            counts.put(record.name, record.count);
        }
        reader.close();
        Assertions.assertEquals((int)3, (int)((Integer)counts.get("apple")));
        Assertions.assertEquals((int)2, (int)((Integer)counts.get("banana")));
        Assertions.assertEquals((int)1, (int)((Integer)counts.get("carrot")));
    }

    @Test
    void avroInput() throws Exception {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.avro").toURI().toString())});
        job.setInputFormatClass(AvroKeyInputFormat.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        job.setMapperClass(StatCountMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(SpecificStatsReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        Path outputPath = new Path(this.tmpFolder.getPath() + "/out-specific-input");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        FileStatus[] outputFiles = fileSystem.globStatus(outputPath.suffix("/part-*"));
        Assertions.assertEquals((int)1, (int)outputFiles.length);
        DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new SpecificDatumReader());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (TextStats record : reader) {
            counts.put(record.getName().toString(), record.getCount());
        }
        reader.close();
        Assertions.assertEquals((int)3, (int)((Integer)counts.get("apple")));
        Assertions.assertEquals((int)2, (int)((Integer)counts.get("banana")));
        Assertions.assertEquals((int)1, (int)((Integer)counts.get("carrot")));
    }

    @Test
    void reflectInput() throws Exception {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.avro").toURI().toString())});
        job.setInputFormatClass(AvroKeyInputFormat.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)REFLECT_STATS_SCHEMA);
        job.setMapperClass(ReflectCountMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(ReflectStatsReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)REFLECT_STATS_SCHEMA);
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        Path outputPath = new Path(this.tmpFolder.getPath() + "/out-reflect-input");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        FileStatus[] outputFiles = fileSystem.globStatus(outputPath.suffix("/part-*"));
        Assertions.assertEquals((int)1, (int)outputFiles.length);
        DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new ReflectDatumReader());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (ReflectStats record : reader) {
            counts.put(record.name, record.count);
        }
        reader.close();
        Assertions.assertEquals((int)3, (int)((Integer)counts.get("apple")));
        Assertions.assertEquals((int)2, (int)((Integer)counts.get("banana")));
        Assertions.assertEquals((int)1, (int)((Integer)counts.get("carrot")));
    }

    @Test
    void avroMapOutput() throws Exception {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.avro").toURI().toString())});
        job.setInputFormatClass(AvroKeyInputFormat.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        job.setMapperClass(SortMapper.class);
        AvroJob.setMapOutputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        job.setMapOutputValueClass(NullWritable.class);
        job.setReducerClass(SortReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)TextStats.SCHEMA$);
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        Path outputPath = new Path(this.tmpFolder.getPath() + "/out-specific-input");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        FileStatus[] outputFiles = fileSystem.globStatus(outputPath.suffix("/part-*"));
        Assertions.assertEquals((int)1, (int)outputFiles.length);
        DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(outputFiles[0].getPath(), job.getConfiguration()), (DatumReader)new SpecificDatumReader());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (TextStats record : reader) {
            counts.put(record.getName().toString(), record.getCount());
        }
        reader.close();
        Assertions.assertEquals((int)3, (int)((Integer)counts.get("apple")));
        Assertions.assertEquals((int)2, (int)((Integer)counts.get("banana")));
        Assertions.assertEquals((int)1, (int)((Integer)counts.get("carrot")));
    }

    @Test
    void avroUsingTextFileOutput() throws Exception {
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.getClass().getResource("/org/apache/avro/mapreduce/mapreduce-test-input.txt").toURI().toString())});
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(LineCountMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(AvroSumReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        AvroJob.setOutputValueSchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.INT));
        job.setOutputFormatClass(TextOutputFormat.class);
        Path outputPath = new Path(this.tmpFolder.getPath() + "/out-text");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        FileStatus[] outputFiles = fileSystem.globStatus(outputPath.suffix("/part-*"));
        Assertions.assertEquals((int)1, (int)outputFiles.length);
        Path filePath = outputFiles[0].getPath();
        FSDataInputStream inputStream = filePath.getFileSystem(job.getConfiguration()).open(filePath);
        Assertions.assertNotNull((Object)inputStream);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream));){
            Assertions.assertTrue((boolean)reader.ready());
            Assertions.assertEquals((Object)"apple\t3", (Object)reader.readLine());
            Assertions.assertEquals((Object)"banana\t2", (Object)reader.readLine());
            Assertions.assertEquals((Object)"carrot\t1", (Object)reader.readLine());
            Assertions.assertFalse((boolean)reader.ready());
        }
    }

    static {
        REFLECT_STATS_SCHEMA.addAlias(TextStats.SCHEMA$.getFullName());
    }

    private static class LineCountMapper
    extends Mapper<LongWritable, Text, Text, IntWritable> {
        private IntWritable mOne;

        private LineCountMapper() {
        }

        protected void setup(Mapper.Context context) {
            this.mOne = new IntWritable(1);
        }

        protected void map(LongWritable fileByteOffset, Text line, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)line, (Object)this.mOne);
        }
    }

    private static class GenericStatsReducer
    extends Reducer<Text, IntWritable, AvroKey<GenericData.Record>, NullWritable> {
        private AvroKey<GenericData.Record> mStats;

        private GenericStatsReducer() {
        }

        protected void setup(Reducer.Context context) {
            this.mStats = new AvroKey(null);
        }

        protected void reduce(Text line, Iterable<IntWritable> counts, Reducer.Context context) throws IOException, InterruptedException {
            GenericData.Record record = new GenericData.Record(STATS_SCHEMA);
            int sum = 0;
            for (IntWritable count : counts) {
                sum += count.get();
            }
            record.put("name", (Object)new Utf8(line.toString()));
            record.put("count", (Object)sum);
            this.mStats.datum((Object)record);
            context.write(this.mStats, (Object)NullWritable.get());
        }
    }

    private static class SpecificStatsReducer
    extends Reducer<Text, IntWritable, AvroKey<TextStats>, NullWritable> {
        private AvroKey<TextStats> mStats;

        private SpecificStatsReducer() {
        }

        protected void setup(Reducer.Context context) {
            this.mStats = new AvroKey(null);
        }

        protected void reduce(Text line, Iterable<IntWritable> counts, Reducer.Context context) throws IOException, InterruptedException {
            TextStats record = new TextStats();
            record.setCount(0);
            for (IntWritable count : counts) {
                record.setCount(record.getCount() + count.get());
            }
            record.setName(line.toString());
            this.mStats.datum((Object)record);
            context.write(this.mStats, (Object)NullWritable.get());
        }
    }

    private static class ReflectStatsReducer
    extends Reducer<Text, IntWritable, AvroKey<ReflectStats>, NullWritable> {
        private AvroKey<ReflectStats> mStats;

        private ReflectStatsReducer() {
        }

        protected void setup(Reducer.Context context) {
            this.mStats = new AvroKey(null);
        }

        protected void reduce(Text line, Iterable<IntWritable> counts, Reducer.Context context) throws IOException, InterruptedException {
            ReflectStats record = new ReflectStats();
            record.count = 0;
            for (IntWritable count : counts) {
                record.count += count.get();
            }
            record.name = line.toString();
            this.mStats.datum((Object)record);
            context.write(this.mStats, (Object)NullWritable.get());
        }
    }

    public static class ReflectStats {
        String name;
        int count;
    }

    private static class StatCountMapper
    extends Mapper<AvroKey<TextStats>, NullWritable, Text, IntWritable> {
        private IntWritable mCount;
        private Text mText;

        private StatCountMapper() {
        }

        protected void setup(Mapper.Context context) {
            this.mCount = new IntWritable(0);
            this.mText = new Text("");
        }

        protected void map(AvroKey<TextStats> record, NullWritable ignore, Mapper.Context context) throws IOException, InterruptedException {
            this.mCount.set(((TextStats)((Object)record.datum())).getCount());
            this.mText.set(((TextStats)((Object)record.datum())).getName().toString());
            context.write((Object)this.mText, (Object)this.mCount);
        }
    }

    private static class ReflectCountMapper
    extends Mapper<AvroKey<ReflectStats>, NullWritable, Text, IntWritable> {
        private IntWritable mCount;
        private Text mText;

        private ReflectCountMapper() {
        }

        protected void setup(Mapper.Context context) {
            this.mCount = new IntWritable(0);
            this.mText = new Text("");
        }

        protected void map(AvroKey<ReflectStats> record, NullWritable ignore, Mapper.Context context) throws IOException, InterruptedException {
            this.mCount.set(((ReflectStats)record.datum()).count);
            this.mText.set(((ReflectStats)record.datum()).name);
            context.write((Object)this.mText, (Object)this.mCount);
        }
    }

    private static class SortMapper
    extends Mapper<AvroKey<TextStats>, NullWritable, AvroKey<TextStats>, NullWritable> {
        private SortMapper() {
        }

        protected void map(AvroKey<TextStats> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            context.write(key, (Object)value);
        }
    }

    private static class SortReducer
    extends Reducer<AvroKey<TextStats>, NullWritable, AvroKey<TextStats>, NullWritable> {
        private SortReducer() {
        }

        protected void reduce(AvroKey<TextStats> key, Iterable<NullWritable> ignore, Reducer.Context context) throws IOException, InterruptedException {
            context.write(key, (Object)NullWritable.get());
        }
    }

    private static class AvroSumReducer
    extends Reducer<Text, IntWritable, AvroKey<CharSequence>, AvroValue<Integer>> {
        private AvroSumReducer() {
        }

        protected void reduce(Text key, Iterable<IntWritable> counts, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable count : counts) {
                sum += count.get();
            }
            context.write((Object)new AvroKey((Object)key.toString()), (Object)new AvroValue((Object)sum));
        }
    }
}

