/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.SeekableFileInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroFiles;
import org.apache.avro.mapreduce.AvroKeyValueRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAvroKeyValueRecordReader {
    @TempDir
    public File mTempDir;

    @Test
    void readRecords() throws IOException, InterruptedException {
        Schema keyValueSchema = AvroKeyValue.getSchema((Schema)Schema.create((Schema.Type)Schema.Type.STRING), (Schema)Schema.create((Schema.Type)Schema.Type.INT));
        AvroKeyValue firstInputRecord = new AvroKeyValue((GenericRecord)new GenericData.Record(keyValueSchema));
        firstInputRecord.setKey((Object)"first");
        firstInputRecord.setValue((Object)1);
        AvroKeyValue secondInputRecord = new AvroKeyValue((GenericRecord)new GenericData.Record(keyValueSchema));
        secondInputRecord.setKey((Object)"second");
        secondInputRecord.setValue((Object)2);
        SeekableFileInput avroFileInput = new SeekableFileInput(AvroFiles.createFile(new File(this.mTempDir, "myInputFile.avro"), keyValueSchema, firstInputRecord.get(), secondInputRecord.get()));
        AvroKeyValueRecordReader<CharSequence, Integer> recordReader = new AvroKeyValueRecordReader<CharSequence, Integer>(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.INT), (SeekableInput)avroFileInput){
            final /* synthetic */ SeekableInput val$avroFileInput;
            {
                this.val$avroFileInput = seekableInput;
                super(keyReaderSchema, valueReaderSchema);
            }

            protected SeekableInput createSeekableInput(Configuration conf, Path path) throws IOException {
                return this.val$avroFileInput;
            }
        };
        Configuration conf = new Configuration();
        FileSplit inputSplit = (FileSplit)Mockito.mock(FileSplit.class);
        Mockito.when((Object)inputSplit.getPath()).thenReturn((Object)new Path("/path/to/an/avro/file"));
        Mockito.when((Object)inputSplit.getStart()).thenReturn((Object)0L);
        Mockito.when((Object)inputSplit.getLength()).thenReturn((Object)avroFileInput.length());
        TaskAttemptContext context = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)conf);
        recordReader.initialize((InputSplit)inputSplit, context);
        Assertions.assertEquals((float)0.0f, (float)recordReader.getProgress(), (float)0.0f, (String)"Progress should be zero before any records are read");
        Assertions.assertTrue((boolean)recordReader.nextKeyValue(), (String)"Expected at least one record");
        AvroKey key = (AvroKey)recordReader.getCurrentKey();
        AvroValue value = (AvroValue)recordReader.getCurrentValue();
        Assertions.assertNotNull((Object)key, (String)"First record had null key");
        Assertions.assertNotNull((Object)value, (String)"First record had null value");
        Assertions.assertEquals((Object)"first", (Object)((CharSequence)key.datum()).toString());
        Assertions.assertEquals((int)1, (int)((Integer)value.datum()));
        Assertions.assertEquals((Object)key, (Object)recordReader.getCurrentKey());
        Assertions.assertEquals((Object)value, (Object)recordReader.getCurrentValue());
        Assertions.assertTrue((boolean)recordReader.nextKeyValue(), (String)"Expected to read a second record");
        key = (AvroKey)recordReader.getCurrentKey();
        value = (AvroValue)recordReader.getCurrentValue();
        Assertions.assertNotNull((Object)key, (String)"Second record had null key");
        Assertions.assertNotNull((Object)value, (String)"Second record had null value");
        Assertions.assertEquals((Object)"second", (Object)((CharSequence)key.datum()).toString());
        Assertions.assertEquals((int)2, (int)((Integer)value.datum()));
        Assertions.assertEquals((float)1.0f, (float)recordReader.getProgress(), (float)0.0f, (String)"Progress should be complete (2 out of 2 records processed)");
        Assertions.assertFalse((boolean)recordReader.nextKeyValue(), (String)"Expected only 2 records");
        recordReader.close();
        ((FileSplit)Mockito.verify((Object)inputSplit)).getPath();
        ((FileSplit)Mockito.verify((Object)inputSplit, (VerificationMode)Mockito.times((int)2))).getStart();
        ((FileSplit)Mockito.verify((Object)inputSplit)).getLength();
        ((TaskAttemptContext)Mockito.verify((Object)context, (VerificationMode)Mockito.atLeastOnce())).getConfiguration();
    }
}

