/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.generic.GenericData;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAvroKeyOutputFormat {
    private static final String SYNC_INTERVAL_KEY = "avro.mapred.sync.interval";
    private static final int TEST_SYNC_INTERVAL = 12345;
    @TempDir
    public File mTempDir;

    @Test
    void withNullCodec() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt(SYNC_INTERVAL_KEY, 12345);
        this.testGetRecordWriter(conf, CodecFactory.nullCodec(), 12345);
    }

    @Test
    void withDeflateCodec() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.setInt("avro.mapred.deflate.level", 3);
        this.testGetRecordWriter(conf, CodecFactory.deflateCodec((int)3), 64000);
    }

    @Test
    void withSnappyCode() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("avro.output.codec", "snappy");
        conf.setInt(SYNC_INTERVAL_KEY, 12345);
        this.testGetRecordWriter(conf, CodecFactory.snappyCodec(), 12345);
    }

    @Test
    void withBZip2Code() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("avro.output.codec", "bzip2");
        this.testGetRecordWriter(conf, CodecFactory.bzip2Codec(), 64000);
    }

    @Test
    void withZstandardCode() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("avro.output.codec", "zstandard");
        this.testGetRecordWriter(conf, CodecFactory.zstandardCodec((int)3), 64000);
    }

    @Test
    void withDeflateCodeWithHadoopConfig() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.DeflateCodec");
        conf.setInt("avro.mapred.deflate.level", -1);
        conf.setInt(SYNC_INTERVAL_KEY, 12345);
        this.testGetRecordWriter(conf, CodecFactory.deflateCodec((int)-1), 12345);
    }

    @Test
    void withSnappyCodeWithHadoopConfig() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.SnappyCodec");
        this.testGetRecordWriter(conf, CodecFactory.snappyCodec(), 64000);
    }

    @Test
    void withBZip2CodeWithHadoopConfig() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.BZip2Codec");
        conf.setInt(SYNC_INTERVAL_KEY, 12345);
        this.testGetRecordWriter(conf, CodecFactory.bzip2Codec(), 12345);
    }

    private void testGetRecordWriter(Configuration conf, CodecFactory expectedCodec, int expectedSyncInterval) throws IOException {
        Job job = Job.getInstance((Configuration)conf);
        job.getConfiguration().set("mapred.output.dir", this.mTempDir.getPath());
        Schema writerSchema = Schema.create((Schema.Type)Schema.Type.INT);
        AvroJob.setOutputKeySchema((Job)job, (Schema)writerSchema);
        TaskAttemptContext context = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)job.getConfiguration());
        Mockito.when((Object)context.getTaskAttemptID()).thenReturn((Object)TaskAttemptID.forName((String)"attempt_200707121733_0001_m_000000_0"));
        Mockito.when((Object)context.getNumReduceTasks()).thenReturn((Object)1);
        RecordWriter expectedRecordWriter = (RecordWriter)Mockito.mock(RecordWriter.class);
        AvroKeyOutputFormat.RecordWriterFactory recordWriterFactory = (AvroKeyOutputFormat.RecordWriterFactory)Mockito.mock(AvroKeyOutputFormat.RecordWriterFactory.class);
        ArgumentCaptor capturedCodecFactory = ArgumentCaptor.forClass(CodecFactory.class);
        Mockito.when((Object)recordWriterFactory.create((Schema)Mockito.eq((Object)writerSchema), (GenericData)Mockito.any(GenericData.class), (CodecFactory)capturedCodecFactory.capture(), (OutputStream)Mockito.any(OutputStream.class), Mockito.eq((int)expectedSyncInterval))).thenReturn((Object)expectedRecordWriter);
        AvroKeyOutputFormat outputFormat = new AvroKeyOutputFormat(recordWriterFactory);
        RecordWriter recordWriter = outputFormat.getRecordWriter(context);
        Assertions.assertNotNull((Object)capturedCodecFactory.getValue());
        Assertions.assertEquals((Object)expectedCodec.toString(), (Object)((CodecFactory)capturedCodecFactory.getValue()).toString());
        ((TaskAttemptContext)Mockito.verify((Object)context, (VerificationMode)Mockito.atLeastOnce())).getConfiguration();
        ((AvroKeyOutputFormat.RecordWriterFactory)Mockito.verify((Object)recordWriterFactory)).create((Schema)Mockito.eq((Object)writerSchema), (GenericData)Mockito.any(ReflectData.class), (CodecFactory)Mockito.any(CodecFactory.class), (OutputStream)Mockito.any(OutputStream.class), Mockito.anyInt());
        Assertions.assertNotNull((Object)recordWriter);
        Assertions.assertSame((Object)expectedRecordWriter, (Object)recordWriter);
    }
}

