/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestAvroKeyInputFormat {
    @Test
    void createRecordReader() throws IOException, InterruptedException {
        Job job = Job.getInstance();
        AvroJob.setInputKeySchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        Configuration conf = job.getConfiguration();
        FileSplit inputSplit = (FileSplit)Mockito.mock(FileSplit.class);
        TaskAttemptContext context = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)conf);
        AvroKeyInputFormat inputFormat = new AvroKeyInputFormat();
        RecordReader recordReader = inputFormat.createRecordReader((InputSplit)inputSplit, context);
        Assertions.assertNotNull((Object)inputFormat);
        recordReader.close();
        ((TaskAttemptContext)Mockito.verify((Object)context)).getConfiguration();
    }
}

