/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.AvroTextOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestAvroTextOutputFormat {
    @TempDir
    public File tmpFolder;

    @Test
    void avroTextRecordWriter() throws Exception {
        File file = new File(this.tmpFolder.getPath(), "writer");
        Schema schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter fileWriter = new DataFileWriter((DatumWriter)datumWriter);
        fileWriter.create(schema, file);
        AvroTextOutputFormat.AvroTextRecordWriter rw = new AvroTextOutputFormat.AvroTextRecordWriter(new AvroTextOutputFormat(), fileWriter, "\t".getBytes(StandardCharsets.UTF_8));
        rw.write(null, null);
        rw.write(null, (Object)NullWritable.get());
        rw.write((Object)NullWritable.get(), null);
        rw.write((Object)NullWritable.get(), (Object)NullWritable.get());
        rw.write((Object)"k1", null);
        rw.write((Object)"k2", (Object)NullWritable.get());
        rw.write(null, (Object)"v1");
        rw.write((Object)NullWritable.get(), (Object)"v2");
        rw.write((Object)"k3", (Object)"v3");
        rw.write((Object)new Text("k4"), (Object)new Text("v4"));
        rw.close(null);
        GenericDatumReader reader = new GenericDatumReader();
        DataFileReader fileReader = new DataFileReader(file, (DatumReader)reader);
        Assertions.assertEquals((Object)"k1", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assertions.assertEquals((Object)"k2", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assertions.assertEquals((Object)"v1", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assertions.assertEquals((Object)"v2", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assertions.assertEquals((Object)"k3\tv3", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assertions.assertEquals((Object)"k4\tv4", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assertions.assertFalse((boolean)fileReader.hasNext(), (String)"End");
        fileReader.close();
    }

    private String asString(ByteBuffer buf) {
        byte[] b = new byte[buf.remaining()];
        buf.get(b);
        return new String(b, StandardCharsets.UTF_8);
    }
}

