/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import org.apache.avro.file.CodecFactory;
import org.apache.avro.mapred.AvroOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAvroOutputFormat {
    @Test
    void setSyncInterval() {
        JobConf jobConf = new JobConf();
        int newSyncInterval = 100000;
        AvroOutputFormat.setSyncInterval((JobConf)jobConf, (int)newSyncInterval);
        Assertions.assertEquals((int)newSyncInterval, (int)jobConf.getInt("avro.mapred.sync.interval", -1));
    }

    @Test
    void noCodec() {
        JobConf job = new JobConf();
        Assertions.assertNull((Object)AvroOutputFormat.getCodecFactory((JobConf)job));
        job = new JobConf();
        job.set("mapred.output.compress", "false");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.BZip2Codec");
        Assertions.assertNull((Object)AvroOutputFormat.getCodecFactory((JobConf)job));
        job = new JobConf();
        job.set("mapred.output.compress", "false");
        job.set("avro.output.codec", "bzip2");
        Assertions.assertNull((Object)AvroOutputFormat.getCodecFactory((JobConf)job));
    }

    @Test
    void bZip2CodecUsingHadoopClass() {
        CodecFactory avroBZip2Codec = CodecFactory.fromString((String)"bzip2");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.BZip2Codec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assertions.assertNotNull((Object)factory);
        Assertions.assertEquals(factory.getClass(), avroBZip2Codec.getClass());
    }

    @Test
    void bZip2CodecUsingAvroCodec() {
        CodecFactory avroBZip2Codec = CodecFactory.fromString((String)"bzip2");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("avro.output.codec", "bzip2");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assertions.assertNotNull((Object)factory);
        Assertions.assertEquals(factory.getClass(), avroBZip2Codec.getClass());
    }

    @Test
    void deflateCodecUsingHadoopClass() {
        CodecFactory avroDeflateCodec = CodecFactory.fromString((String)"deflate");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.DeflateCodec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assertions.assertNotNull((Object)factory);
        Assertions.assertEquals(factory.getClass(), avroDeflateCodec.getClass());
    }

    @Test
    void deflateCodecUsingAvroCodec() {
        CodecFactory avroDeflateCodec = CodecFactory.fromString((String)"deflate");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("avro.output.codec", "deflate");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assertions.assertNotNull((Object)factory);
        Assertions.assertEquals(factory.getClass(), avroDeflateCodec.getClass());
    }

    @Test
    void snappyCodecUsingHadoopClass() {
        CodecFactory avroSnappyCodec = CodecFactory.fromString((String)"snappy");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.SnappyCodec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assertions.assertNotNull((Object)factory);
        Assertions.assertEquals(factory.getClass(), avroSnappyCodec.getClass());
    }

    @Test
    void snappyCodecUsingAvroCodec() {
        CodecFactory avroSnappyCodec = CodecFactory.fromString((String)"snappy");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("avro.output.codec", "snappy");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assertions.assertNotNull((Object)factory);
        Assertions.assertEquals(factory.getClass(), avroSnappyCodec.getClass());
    }

    @Test
    void gZipCodecUsingHadoopClass() {
        CodecFactory avroDeflateCodec = CodecFactory.fromString((String)"deflate");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.GZipCodec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assertions.assertNotNull((Object)factory);
        Assertions.assertEquals(factory.getClass(), avroDeflateCodec.getClass());
    }
}

