/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.hadoop.io.AvroDatumConverter;
import org.apache.avro.hadoop.io.AvroDatumConverterFactory;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAvroDatumConverterFactory {
    private Job mJob;
    private AvroDatumConverterFactory mFactory;

    @BeforeEach
    public void setup() throws IOException {
        this.mJob = Job.getInstance();
        this.mFactory = new AvroDatumConverterFactory(this.mJob.getConfiguration());
    }

    @Test
    void convertAvroKey() throws IOException {
        AvroJob.setOutputKeySchema((Job)this.mJob, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        AvroKey avroKey = new AvroKey((Object)"foo");
        AvroDatumConverter converter = this.mFactory.create(avroKey.getClass());
        Assertions.assertEquals((Object)"foo", (Object)converter.convert((Object)avroKey).toString());
    }

    @Test
    void convertAvroValue() throws IOException {
        AvroJob.setOutputValueSchema((Job)this.mJob, (Schema)Schema.create((Schema.Type)Schema.Type.INT));
        AvroValue avroValue = new AvroValue((Object)42);
        AvroDatumConverter converter = this.mFactory.create(avroValue.getClass());
        Assertions.assertEquals((int)42, (int)((Integer)converter.convert((Object)avroValue)));
    }

    @Test
    void convertBooleanWritable() {
        AvroDatumConverter converter = this.mFactory.create(BooleanWritable.class);
        Assertions.assertEquals((Object)true, (Object)converter.convert((Object)new BooleanWritable(true)));
    }

    @Test
    void convertBytesWritable() {
        AvroDatumConverter converter = this.mFactory.create(BytesWritable.class);
        ByteBuffer bytes = (ByteBuffer)converter.convert((Object)new BytesWritable(new byte[]{1, 2, 3}));
        Assertions.assertEquals((int)1, (int)bytes.get(0));
        Assertions.assertEquals((int)2, (int)bytes.get(1));
        Assertions.assertEquals((int)3, (int)bytes.get(2));
    }

    @Test
    void convertByteWritable() {
        AvroDatumConverter converter = this.mFactory.create(ByteWritable.class);
        Assertions.assertEquals((int)42, (int)((GenericFixed)converter.convert((Object)new ByteWritable(42))).bytes()[0]);
    }

    @Test
    void convertDoubleWritable() {
        AvroDatumConverter converter = this.mFactory.create(DoubleWritable.class);
        Assertions.assertEquals((double)2.0, (double)((Double)converter.convert((Object)new DoubleWritable(2.0))), (double)1.0E-5);
    }

    @Test
    void convertFloatWritable() {
        AvroDatumConverter converter = this.mFactory.create(FloatWritable.class);
        Assertions.assertEquals((double)2.2f, (double)((Float)converter.convert((Object)new FloatWritable(2.2f))).floatValue(), (double)1.0E-5);
    }

    @Test
    void convertIntWritable() {
        AvroDatumConverter converter = this.mFactory.create(IntWritable.class);
        Assertions.assertEquals((int)2, (int)((Integer)converter.convert((Object)new IntWritable(2))));
    }

    @Test
    void convertLongWritable() {
        AvroDatumConverter converter = this.mFactory.create(LongWritable.class);
        Assertions.assertEquals((long)123L, (long)((Long)converter.convert((Object)new LongWritable(123L))));
    }

    @Test
    void convertNullWritable() {
        AvroDatumConverter converter = this.mFactory.create(NullWritable.class);
        Assertions.assertNull((Object)converter.convert((Object)NullWritable.get()));
    }

    @Test
    void convertText() {
        AvroDatumConverter converter = this.mFactory.create(Text.class);
        Assertions.assertEquals((Object)"foo", (Object)((CharSequence)converter.convert((Object)new Text("foo"))).toString());
    }
}

