/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.file.SortedKeyValueFile;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSortedKeyValueFile {
    private static final Logger LOG = LoggerFactory.getLogger(TestSortedKeyValueFile.class);
    @TempDir
    public File mTempDir;

    @Test
    void writeOutOfSortedOrder() throws IOException {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            LOG.debug("Writing some records to a SortedKeyValueFile...");
            Configuration conf = new Configuration();
            SortedKeyValueFile.Writer.Options options = new SortedKeyValueFile.Writer.Options().withKeySchema(Schema.create((Schema.Type)Schema.Type.STRING)).withValueSchema(Schema.create((Schema.Type)Schema.Type.STRING)).withConfiguration(conf).withPath(new Path(this.mTempDir.getPath(), "myfile")).withIndexInterval(2);
            try (SortedKeyValueFile.Writer writer = new SortedKeyValueFile.Writer(options);){
                Utf8 key = new Utf8();
                writer.append((Object)key.set("banana"), (Object)"Banana");
                writer.append((Object)key.set("apple"), (Object)"Apple");
            }
        });
    }

    @Test
    void namedCodecs() throws IOException {
        Configuration conf = new Configuration();
        Path myfile = new Path(this.mTempDir.getPath(), "myfile");
        Schema key = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema value = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema recordSchema = AvroKeyValue.getSchema((Schema)key, (Schema)value);
        DatumReader datumReader = SpecificData.get().createDatumReader(recordSchema);
        SortedKeyValueFile.Writer.Options options = new SortedKeyValueFile.Writer.Options().withKeySchema(key).withValueSchema(value).withConfiguration(conf).withPath(myfile);
        for (String codec : new String[]{"null", "deflate", "snappy", "bzip2"}) {
            LOG.debug("Using " + codec + "codec for a SortedKeyValueFile...");
            options.withCodec(codec);
            SortedKeyValueFile.Writer writer = new SortedKeyValueFile.Writer(options);
            writer.close();
            DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(new Path(myfile, "data"), conf), datumReader);
            Assertions.assertEquals((Object)codec, (Object)reader.getMetaString("avro.codec"));
            reader.close();
        }
    }

    @Test
    void deflateClassCodec() throws IOException {
        Configuration conf = new Configuration();
        Path myfile = new Path(this.mTempDir.getPath(), "myfile");
        Schema key = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema value = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema recordSchema = AvroKeyValue.getSchema((Schema)key, (Schema)value);
        DatumReader datumReader = SpecificData.get().createDatumReader(recordSchema);
        LOG.debug("Using CodecFactory.deflateCodec() for a SortedKeyValueFile...");
        SortedKeyValueFile.Writer.Options options = new SortedKeyValueFile.Writer.Options().withKeySchema(key).withValueSchema(value).withConfiguration(conf).withPath(myfile).withCodec(CodecFactory.deflateCodec((int)9));
        SortedKeyValueFile.Writer writer = new SortedKeyValueFile.Writer(options);
        writer.close();
        DataFileReader reader = new DataFileReader((SeekableInput)new FsInput(new Path(myfile, "data"), conf), datumReader);
        Assertions.assertEquals((Object)"deflate", (Object)reader.getMetaString("avro.codec"));
        reader.close();
    }

    @Test
    void badCodec() throws IOException {
        LOG.debug("Using a bad codec for a SortedKeyValueFile...");
        try {
            new SortedKeyValueFile.Writer.Options().withCodec("foobar");
        }
        catch (AvroRuntimeException e) {
            Assertions.assertEquals((Object)"Unrecognized codec: foobar", (Object)e.getMessage());
        }
    }

    @Test
    void writer() throws IOException {
        LOG.debug("Writing some records to a SortedKeyValueFile...");
        Configuration conf = new Configuration();
        SortedKeyValueFile.Writer.Options options = new SortedKeyValueFile.Writer.Options().withKeySchema(Schema.create((Schema.Type)Schema.Type.STRING)).withValueSchema(Schema.create((Schema.Type)Schema.Type.STRING)).withConfiguration(conf).withPath(new Path(this.mTempDir.getPath(), "myfile")).withIndexInterval(2);
        try (SortedKeyValueFile.Writer writer = new SortedKeyValueFile.Writer(options);){
            writer.append((Object)"apple", (Object)"Apple");
            writer.append((Object)"banana", (Object)"Banana");
            writer.append((Object)"carrot", (Object)"Carrot");
            writer.append((Object)"durian", (Object)"Durian");
        }
        LOG.debug("Checking the generated directory...");
        File directory = new File(this.mTempDir.getPath(), "myfile");
        Assertions.assertTrue((boolean)directory.exists());
        LOG.debug("Checking the generated index file...");
        File indexFile = new File(directory, "index");
        GenericDatumReader indexReader = new GenericDatumReader(AvroKeyValue.getSchema((Schema)options.getKeySchema(), (Schema)Schema.create((Schema.Type)Schema.Type.LONG)));
        ArrayList<AvroKeyValue> indexRecords = new ArrayList<AvroKeyValue>();
        try (FileReader indexFileReader = DataFileReader.openReader((File)indexFile, (DatumReader)indexReader);){
            for (GenericRecord indexRecord : indexFileReader) {
                indexRecords.add(new AvroKeyValue(indexRecord));
            }
        }
        Assertions.assertEquals((int)2, (int)indexRecords.size());
        Assertions.assertEquals((Object)"apple", (Object)((CharSequence)((AvroKeyValue)indexRecords.get(0)).getKey()).toString());
        LOG.debug("apple's position in the file: " + ((AvroKeyValue)indexRecords.get(0)).getValue());
        Assertions.assertEquals((Object)"carrot", (Object)((CharSequence)((AvroKeyValue)indexRecords.get(1)).getKey()).toString());
        LOG.debug("carrot's position in the file: " + ((AvroKeyValue)indexRecords.get(1)).getValue());
        LOG.debug("Checking the generated data file...");
        File dataFile = new File(directory, "data");
        GenericDatumReader dataReader = new GenericDatumReader(AvroKeyValue.getSchema((Schema)options.getKeySchema(), (Schema)options.getValueSchema()));
        try (DataFileReader dataFileReader = new DataFileReader(dataFile, (DatumReader)dataReader);){
            dataFileReader.seek(((Long)((AvroKeyValue)indexRecords.get(0)).getValue()).longValue());
            Assertions.assertTrue((boolean)dataFileReader.hasNext());
            AvroKeyValue appleRecord = new AvroKeyValue((GenericRecord)dataFileReader.next());
            Assertions.assertEquals((Object)"apple", (Object)((CharSequence)appleRecord.getKey()).toString());
            Assertions.assertEquals((Object)"Apple", (Object)((CharSequence)appleRecord.getValue()).toString());
            dataFileReader.seek(((Long)((AvroKeyValue)indexRecords.get(1)).getValue()).longValue());
            Assertions.assertTrue((boolean)dataFileReader.hasNext());
            AvroKeyValue carrotRecord = new AvroKeyValue((GenericRecord)dataFileReader.next());
            Assertions.assertEquals((Object)"carrot", (Object)((CharSequence)carrotRecord.getKey()).toString());
            Assertions.assertEquals((Object)"Carrot", (Object)((CharSequence)carrotRecord.getValue()).toString());
            Assertions.assertTrue((boolean)dataFileReader.hasNext());
            AvroKeyValue durianRecord = new AvroKeyValue((GenericRecord)dataFileReader.next());
            Assertions.assertEquals((Object)"durian", (Object)((CharSequence)durianRecord.getKey()).toString());
            Assertions.assertEquals((Object)"Durian", (Object)((CharSequence)durianRecord.getValue()).toString());
        }
    }

    @Test
    void reader() throws IOException {
        Configuration conf = new Configuration();
        SortedKeyValueFile.Writer.Options writerOptions = new SortedKeyValueFile.Writer.Options().withKeySchema(Schema.create((Schema.Type)Schema.Type.STRING)).withValueSchema(Schema.create((Schema.Type)Schema.Type.STRING)).withConfiguration(conf).withPath(new Path(this.mTempDir.getPath(), "myfile")).withIndexInterval(2);
        try (SortedKeyValueFile.Writer writer = new SortedKeyValueFile.Writer(writerOptions);){
            writer.append((Object)"apple", (Object)"Apple");
            writer.append((Object)"banana", (Object)"Banana");
            writer.append((Object)"carrot", (Object)"Carrot");
            writer.append((Object)"durian", (Object)"Durian");
        }
        LOG.debug("Reading the file back using a reader...");
        SortedKeyValueFile.Reader.Options readerOptions = new SortedKeyValueFile.Reader.Options().withKeySchema(Schema.create((Schema.Type)Schema.Type.STRING)).withValueSchema(Schema.create((Schema.Type)Schema.Type.STRING)).withConfiguration(conf).withPath(new Path(this.mTempDir.getPath(), "myfile"));
        try (SortedKeyValueFile.Reader reader = new SortedKeyValueFile.Reader(readerOptions);){
            Assertions.assertEquals((Object)"Carrot", (Object)((CharSequence)reader.get((Object)"carrot")).toString());
            Assertions.assertEquals((Object)"Banana", (Object)((CharSequence)reader.get((Object)"banana")).toString());
            Assertions.assertNull((Object)reader.get((Object)"a-vegetable"));
            Assertions.assertNull((Object)reader.get((Object)"beet"));
            Assertions.assertNull((Object)reader.get((Object)"zzz"));
        }
    }

    @Test
    void alternateModel() throws Exception {
        LOG.debug("Writing some reflect records...");
        ReflectData model = ReflectData.get();
        Configuration conf = new Configuration();
        SortedKeyValueFile.Writer.Options options = new SortedKeyValueFile.Writer.Options().withKeySchema(model.getSchema(Stringy.class)).withValueSchema(model.getSchema(Stringy.class)).withConfiguration(conf).withPath(new Path(this.mTempDir.getPath(), "reflect")).withDataModel((GenericData)model).withIndexInterval(2);
        try (SortedKeyValueFile.Writer writer = new SortedKeyValueFile.Writer(options);){
            writer.append((Object)new Stringy("apple"), (Object)new Stringy("Apple"));
            writer.append((Object)new Stringy("banana"), (Object)new Stringy("Banana"));
            writer.append((Object)new Stringy("carrot"), (Object)new Stringy("Carrot"));
            writer.append((Object)new Stringy("durian"), (Object)new Stringy("Durian"));
        }
        LOG.debug("Reading the file back using a reader...");
        SortedKeyValueFile.Reader.Options readerOptions = new SortedKeyValueFile.Reader.Options().withKeySchema(model.getSchema(Stringy.class)).withValueSchema(model.getSchema(Stringy.class)).withConfiguration(conf).withPath(new Path(this.mTempDir.getPath(), "reflect")).withDataModel((GenericData)model);
        try (SortedKeyValueFile.Reader reader = new SortedKeyValueFile.Reader(readerOptions);){
            Assertions.assertEquals((Object)new Stringy("Carrot"), (Object)reader.get((Object)new Stringy("carrot")));
            Assertions.assertEquals((Object)new Stringy("Banana"), (Object)reader.get((Object)new Stringy("banana")));
            Assertions.assertNull((Object)reader.get((Object)new Stringy("a-vegetable")));
            Assertions.assertNull((Object)reader.get((Object)new Stringy("beet")));
            Assertions.assertNull((Object)reader.get((Object)new Stringy("zzz")));
        }
    }

    public static class Stringy
    implements Comparable<Stringy> {
        private String s;

        public Stringy() {
        }

        public Stringy(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object that) {
            return this.s.equals(that.toString());
        }

        @Override
        public int compareTo(Stringy that) {
            return this.s.compareTo(that.s);
        }
    }
}

