/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroFiles;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyValueOutputFormat;
import org.apache.avro.mapreduce.CombineAvroKeyValueFileInputFormat;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestCombineAvroKeyValueFileInputFormat {
    @TempDir
    public File mTempDir;

    @Test
    void readRecords() throws IOException, InterruptedException, ClassNotFoundException {
        Schema keyValueSchema = AvroKeyValue.getSchema((Schema)Schema.create((Schema.Type)Schema.Type.INT), (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        AvroKeyValue record1 = new AvroKeyValue((GenericRecord)new GenericData.Record(keyValueSchema));
        record1.setKey((Object)1);
        record1.setValue((Object)"apple banana carrot");
        AvroFiles.createFile(new File(this.mTempDir, "combineSplit00.avro"), keyValueSchema, record1.get());
        AvroKeyValue record2 = new AvroKeyValue((GenericRecord)new GenericData.Record(keyValueSchema));
        record2.setKey((Object)2);
        record2.setValue((Object)"apple banana");
        AvroFiles.createFile(new File(this.mTempDir, "combineSplit01.avro"), keyValueSchema, record2.get());
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.mTempDir.getAbsolutePath())});
        job.setInputFormatClass(CombineAvroKeyValueFileInputFormat.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.INT));
        AvroJob.setInputValueSchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        AvroJob.setMapOutputKeySchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.INT));
        AvroJob.setMapOutputValueSchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(AvroKey.class);
        job.setOutputValueClass(AvroValue.class);
        job.setOutputFormatClass(AvroKeyValueOutputFormat.class);
        Path outputPath = new Path(this.mTempDir.getPath(), "out");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        File avroFile = new File(outputPath.toString(), "part-m-00000.avro");
        SpecificDatumReader datumReader = new SpecificDatumReader(AvroKeyValue.getSchema((Schema)Schema.create((Schema.Type)Schema.Type.INT), (Schema)Schema.create((Schema.Type)Schema.Type.STRING)));
        DataFileReader avroFileReader = new DataFileReader(avroFile, (DatumReader)datumReader);
        Assertions.assertTrue((boolean)avroFileReader.hasNext());
        while (avroFileReader.hasNext()) {
            AvroKeyValue mapRecord1 = new AvroKeyValue((GenericRecord)avroFileReader.next());
            Assertions.assertNotNull((Object)mapRecord1.get());
            if ((Integer)mapRecord1.getKey() == 1) {
                Assertions.assertEquals((Object)"apple banana carrot", (Object)((CharSequence)mapRecord1.getValue()).toString());
                continue;
            }
            if ((Integer)mapRecord1.getKey() == 2) {
                Assertions.assertEquals((Object)"apple banana", (Object)((CharSequence)mapRecord1.getValue()).toString());
                continue;
            }
            Assertions.fail((String)("Unknown key " + (Integer)mapRecord1.getKey()));
        }
        avroFileReader.close();
    }
}

