/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.io.AvroDatumConverter;
import org.apache.avro.hadoop.io.AvroDatumConverterFactory;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyValueRecordWriter;
import org.apache.avro.mapreduce.TextStats;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAvroKeyValueRecordWriter {
    @Test
    void writeRecords() throws IOException {
        Job job = Job.getInstance();
        AvroJob.setOutputValueSchema((Job)job, (Schema)TextStats.SCHEMA$);
        TaskAttemptContext context = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        AvroDatumConverterFactory factory = new AvroDatumConverterFactory(job.getConfiguration());
        AvroDatumConverter keyConverter = factory.create(Text.class);
        AvroValue avroValue = new AvroValue(null);
        AvroDatumConverter valueConverter = factory.create(avroValue.getClass());
        CodecFactory compressionCodec = CodecFactory.nullCodec();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        AvroKeyValueRecordWriter writer = new AvroKeyValueRecordWriter(keyConverter, valueConverter, (GenericData)new ReflectData(), compressionCodec, (OutputStream)outputStream);
        TextStats appleStats = new TextStats();
        appleStats.setName("apple");
        writer.write((Object)new Text("apple"), (Object)new AvroValue((Object)appleStats));
        TextStats bananaStats = new TextStats();
        bananaStats.setName("banana");
        writer.write((Object)new Text("banana"), (Object)new AvroValue((Object)bananaStats));
        writer.close(context);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        Schema readerSchema = AvroKeyValue.getSchema((Schema)Schema.create((Schema.Type)Schema.Type.STRING), (Schema)TextStats.SCHEMA$);
        SpecificDatumReader datumReader = new SpecificDatumReader(readerSchema);
        DataFileStream avroFileReader = new DataFileStream((InputStream)inputStream, (DatumReader)datumReader);
        Assertions.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue firstRecord = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assertions.assertNotNull((Object)firstRecord.get());
        Assertions.assertEquals((Object)"apple", (Object)((CharSequence)firstRecord.getKey()).toString());
        Assertions.assertEquals((Object)"apple", (Object)((TextStats)((Object)firstRecord.getValue())).getName().toString());
        Assertions.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue secondRecord = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assertions.assertNotNull((Object)secondRecord.get());
        Assertions.assertEquals((Object)"banana", (Object)((CharSequence)secondRecord.getKey()).toString());
        Assertions.assertEquals((Object)"banana", (Object)((TextStats)((Object)secondRecord.getValue())).getName().toString());
        Assertions.assertFalse((boolean)avroFileReader.hasNext());
        avroFileReader.close();
        ((TaskAttemptContext)Mockito.verify((Object)context, (VerificationMode)Mockito.never())).getConfiguration();
    }

    @Test
    void usingReflection() throws Exception {
        Job job = Job.getInstance();
        Schema schema = ReflectData.get().getSchema(R1.class);
        AvroJob.setOutputValueSchema((Job)job, (Schema)schema);
        TaskAttemptContext context = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        R1 record = new R1();
        record.attribute = "test";
        AvroValue avroValue = new AvroValue((Object)record);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        AvroDatumConverterFactory factory = new AvroDatumConverterFactory(job.getConfiguration());
        AvroDatumConverter keyConverter = factory.create(Text.class);
        AvroDatumConverter valueConverter = factory.create(avroValue.getClass());
        AvroKeyValueRecordWriter writer = new AvroKeyValueRecordWriter(keyConverter, valueConverter, (GenericData)new ReflectData(), CodecFactory.nullCodec(), (OutputStream)outputStream);
        writer.write((Object)new Text("reflectionData"), (Object)avroValue);
        writer.close(context);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        Schema readerSchema = AvroKeyValue.getSchema((Schema)Schema.create((Schema.Type)Schema.Type.STRING), (Schema)schema);
        ReflectDatumReader datumReader = new ReflectDatumReader(readerSchema);
        DataFileStream avroFileReader = new DataFileStream((InputStream)inputStream, (DatumReader)datumReader);
        Assertions.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue firstRecord = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assertions.assertNotNull((Object)firstRecord.get());
        Assertions.assertEquals((Object)"reflectionData", (Object)((CharSequence)firstRecord.getKey()).toString());
        Assertions.assertEquals((Object)record.attribute, (Object)((R1)firstRecord.getValue()).attribute);
        avroFileReader.close();
        ((TaskAttemptContext)Mockito.verify((Object)context, (VerificationMode)Mockito.never())).getConfiguration();
    }

    @Test
    void syncableWriteRecords() throws IOException {
        Job job = Job.getInstance();
        AvroJob.setOutputValueSchema((Job)job, (Schema)TextStats.SCHEMA$);
        TaskAttemptContext context = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        AvroDatumConverterFactory factory = new AvroDatumConverterFactory(job.getConfiguration());
        AvroDatumConverter keyConverter = factory.create(Text.class);
        AvroValue avroValue = new AvroValue(null);
        AvroDatumConverter valueConverter = factory.create(avroValue.getClass());
        CodecFactory compressionCodec = CodecFactory.nullCodec();
        FileOutputStream outputStream = new FileOutputStream(new File("target/temp.avro"));
        AvroKeyValueRecordWriter writer = new AvroKeyValueRecordWriter(keyConverter, valueConverter, (GenericData)new ReflectData(), compressionCodec, (OutputStream)outputStream);
        TextStats appleStats = new TextStats();
        appleStats.setName("apple");
        long pointOne = writer.sync();
        writer.write((Object)new Text("apple"), (Object)new AvroValue((Object)appleStats));
        TextStats bananaStats = new TextStats();
        bananaStats.setName("banana");
        long pointTwo = writer.sync();
        writer.write((Object)new Text("banana"), (Object)new AvroValue((Object)bananaStats));
        writer.close(context);
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "file:///");
        Path avroFile = new Path("target/temp.avro");
        DataFileReader avroFileReader = new DataFileReader((SeekableInput)new FsInput(avroFile, conf), (DatumReader)new SpecificDatumReader());
        avroFileReader.seek(pointTwo);
        Assertions.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue secondRecord = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assertions.assertNotNull((Object)secondRecord.get());
        Assertions.assertEquals((Object)"banana", (Object)((CharSequence)secondRecord.getKey()).toString());
        Assertions.assertEquals((Object)"banana", (Object)((TextStats)((Object)secondRecord.getValue())).getName().toString());
        avroFileReader.seek(pointOne);
        Assertions.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue firstRecord = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assertions.assertNotNull((Object)firstRecord.get());
        Assertions.assertEquals((Object)"apple", (Object)((CharSequence)firstRecord.getKey()).toString());
        Assertions.assertEquals((Object)"apple", (Object)((TextStats)((Object)firstRecord.getValue())).getName().toString());
        avroFileReader.close();
        ((TaskAttemptContext)Mockito.verify((Object)context, (VerificationMode)Mockito.never())).getConfiguration();
    }

    public static class R1 {
        String attribute;
    }
}

