/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.SeekableFileInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroFiles;
import org.apache.avro.mapreduce.AvroKeyRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAvroKeyRecordReader {
    @TempDir
    public File mTempDir;

    @Test
    void readRecords() throws IOException, InterruptedException {
        SeekableFileInput avroFileInput = new SeekableFileInput(AvroFiles.createFile(new File(this.mTempDir, "myStringfile.avro"), Schema.create((Schema.Type)Schema.Type.STRING), "first", "second"));
        Schema readerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        AvroKeyRecordReader<CharSequence> recordReader = new AvroKeyRecordReader<CharSequence>(readerSchema, (SeekableInput)avroFileInput){
            final /* synthetic */ SeekableInput val$avroFileInput;
            {
                this.val$avroFileInput = seekableInput;
                super(readerSchema);
            }

            protected SeekableInput createSeekableInput(Configuration conf, Path path) throws IOException {
                return this.val$avroFileInput;
            }
        };
        Configuration conf = new Configuration();
        FileSplit inputSplit = (FileSplit)Mockito.mock(FileSplit.class);
        Mockito.when((Object)inputSplit.getPath()).thenReturn((Object)new Path("/path/to/an/avro/file"));
        Mockito.when((Object)inputSplit.getStart()).thenReturn((Object)0L);
        Mockito.when((Object)inputSplit.getLength()).thenReturn((Object)avroFileInput.length());
        TaskAttemptContext context = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)conf);
        recordReader.initialize((InputSplit)inputSplit, context);
        Assertions.assertEquals((float)0.0f, (float)recordReader.getProgress(), (float)0.0f, (String)"Progress should be zero before any records are read");
        Assertions.assertTrue((boolean)recordReader.nextKeyValue(), (String)"Expected at least one record");
        AvroKey key = (AvroKey)recordReader.getCurrentKey();
        NullWritable value = (NullWritable)recordReader.getCurrentValue();
        Assertions.assertNotNull((Object)key, (String)"First record had null key");
        Assertions.assertNotNull((Object)value, (String)"First record had null value");
        CharSequence firstString = (CharSequence)key.datum();
        Assertions.assertEquals((Object)"first", (Object)firstString.toString());
        Assertions.assertEquals((Object)key, (Object)recordReader.getCurrentKey());
        Assertions.assertEquals((Object)value, (Object)recordReader.getCurrentValue());
        Assertions.assertTrue((boolean)recordReader.nextKeyValue(), (String)"Expected to read a second record");
        key = (AvroKey)recordReader.getCurrentKey();
        value = (NullWritable)recordReader.getCurrentValue();
        Assertions.assertNotNull((Object)key, (String)"Second record had null key");
        Assertions.assertNotNull((Object)value, (String)"Second record had null value");
        CharSequence secondString = (CharSequence)key.datum();
        Assertions.assertEquals((Object)"second", (Object)secondString.toString());
        Assertions.assertEquals((float)1.0f, (float)recordReader.getProgress(), (float)0.0f, (String)"Progress should be complete (2 out of 2 records processed)");
        Assertions.assertFalse((boolean)recordReader.nextKeyValue(), (String)"Expected only 2 records");
        recordReader.close();
        ((FileSplit)Mockito.verify((Object)inputSplit)).getPath();
        ((FileSplit)Mockito.verify((Object)inputSplit, (VerificationMode)Mockito.times((int)2))).getStart();
        ((FileSplit)Mockito.verify((Object)inputSplit)).getLength();
        ((TaskAttemptContext)Mockito.verify((Object)context, (VerificationMode)Mockito.atLeastOnce())).getConfiguration();
    }
}

