/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.Pair;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.mapred.JobConf;
import org.junit.jupiter.api.Assertions;

public class WordCountUtil {
    public static final String[] LINES = new String[]{"the quick brown fox jumps over the lazy dog", "the cow jumps over the moon", "the rain in spain falls mainly on the plains"};
    public static final Map<String, Long> COUNTS = new TreeMap<String, Long>();
    private static final String STRING_KEY = "string-key";
    private static final String LONG_KEY = "long-key";
    private static final String BYTES_KEY = "bytes-key";
    private static final String STRING_META_VALUE = "value";
    private static final long LONG_META_VALUE = 666L;
    private static final byte[] BYTES_META_VALUE;

    public static void writeLinesFile(String dir) throws IOException {
        WordCountUtil.writeLinesFile(new File(dir));
    }

    public static void writeLinesFile(File dir) throws IOException {
        GenericDatumWriter writer = new GenericDatumWriter();
        try (DataFileWriter out = new DataFileWriter((DatumWriter)writer);){
            out.create(Schema.create((Schema.Type)Schema.Type.STRING), dir);
            for (String line : LINES) {
                out.append((Object)new Utf8(line));
            }
        }
    }

    public static void writeLinesBytesFile(String dir) throws IOException {
        WordCountUtil.writeLinesBytesFile(new File(dir));
    }

    public static void writeLinesBytesFile(File dir) throws IOException {
        FileUtil.fullyDelete((File)dir);
        File fileLines = new File(dir + "/lines.avro");
        fileLines.getParentFile().mkdirs();
        GenericDatumWriter writer = new GenericDatumWriter();
        try (DataFileWriter out = new DataFileWriter((DatumWriter)writer);){
            out.create(Schema.create((Schema.Type)Schema.Type.BYTES), fileLines);
            for (String line : LINES) {
                out.append((Object)ByteBuffer.wrap(line.getBytes(StandardCharsets.UTF_8)));
            }
        }
    }

    public static void writeLinesTextFile(File dir) throws IOException {
        FileUtil.fullyDelete((File)dir);
        File fileLines = new File(dir, "lines.avro");
        fileLines.getParentFile().mkdirs();
        try (PrintStream out = new PrintStream(fileLines);){
            for (String line : LINES) {
                out.println(line);
            }
        }
    }

    public static void validateCountsFile(File file) throws Exception {
        int numWords = 0;
        SpecificDatumReader reader = new SpecificDatumReader();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
             DataFileStream counts = new DataFileStream((InputStream)in, (DatumReader)reader);){
            for (Pair wc : counts) {
                Assertions.assertEquals((Long)COUNTS.get(((Utf8)wc.key()).toString()), (Long)((Long)wc.value()), (String)((Utf8)wc.key()).toString());
                ++numWords;
            }
            WordCountUtil.checkMeta(counts);
        }
        Assertions.assertEquals((int)COUNTS.size(), (int)numWords);
    }

    public static void validateSortedFile(String file) throws Exception {
        WordCountUtil.validateSortedFile(new File(file));
    }

    public static void validateSortedFile(File file) throws Exception {
        GenericDatumReader reader = new GenericDatumReader();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
             DataFileStream lines = new DataFileStream((InputStream)in, (DatumReader)reader);){
            ArrayList<String> sortedLines = new ArrayList<String>(Arrays.asList(LINES));
            Collections.sort(sortedLines);
            for (String expectedLine : sortedLines) {
                ByteBuffer buf = (ByteBuffer)lines.next();
                byte[] b = new byte[buf.remaining()];
                buf.get(b);
                Assertions.assertEquals((Object)expectedLine, (Object)new String(b, StandardCharsets.UTF_8).trim());
            }
            Assertions.assertFalse((boolean)lines.hasNext());
        }
    }

    public static void setMeta(JobConf job) {
        AvroJob.setOutputMeta((JobConf)job, (String)STRING_KEY, (String)STRING_META_VALUE);
        AvroJob.setOutputMeta((JobConf)job, (String)LONG_KEY, (long)666L);
        AvroJob.setOutputMeta((JobConf)job, (String)BYTES_KEY, (byte[])BYTES_META_VALUE);
    }

    public static void checkMeta(DataFileStream<?> in) throws Exception {
        Assertions.assertEquals((Object)STRING_META_VALUE, (Object)in.getMetaString(STRING_KEY));
        Assertions.assertEquals((long)666L, (long)in.getMetaLong(LONG_KEY));
        Assertions.assertTrue((boolean)Arrays.equals(BYTES_META_VALUE, in.getMeta(BYTES_KEY)));
    }

    static {
        for (String line : LINES) {
            StringTokenizer tokens = new StringTokenizer(line);
            while (tokens.hasMoreTokens()) {
                String word = tokens.nextToken();
                long count = COUNTS.getOrDefault(word, 0L);
                COUNTS.put(word, ++count);
            }
        }
        BYTES_META_VALUE = new byte[]{0, -128, -1};
    }
}

