/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.AvroCollector;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.AvroReducer;
import org.apache.avro.mapred.Pair;
import org.apache.avro.mapred.WordCountUtil;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReflectJob {
    @Test
    void job() throws Exception {
        JobConf job = new JobConf();
        String dir = "target/testReflectJob";
        Path inputPath = new Path(dir + "/in");
        Path outputPath = new Path(dir + "/out");
        outputPath.getFileSystem((Configuration)job).delete(outputPath);
        inputPath.getFileSystem((Configuration)job).delete(inputPath);
        this.writeLinesFile(new File(dir + "/in"));
        job.setJobName("reflect");
        AvroJob.setInputSchema((JobConf)job, (Schema)ReflectData.get().getSchema(Text.class));
        AvroJob.setMapOutputSchema((JobConf)job, (Schema)new Pair((Object)new Text(""), (Object)new Count(0L)).getSchema());
        AvroJob.setOutputSchema((JobConf)job, (Schema)ReflectData.get().getSchema(WordCount.class));
        AvroJob.setMapperClass((JobConf)job, MapImpl.class);
        AvroJob.setReducerClass((JobConf)job, ReduceImpl.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inputPath});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
        AvroJob.setReflect((JobConf)job);
        JobClient.runJob((JobConf)job);
        this.validateCountsFile(new File(new File(dir, "out"), "part-00000.avro"));
    }

    private void writeLinesFile(File dir) throws IOException {
        ReflectDatumWriter writer = new ReflectDatumWriter();
        DataFileWriter out = new DataFileWriter((DatumWriter)writer);
        File linesFile = new File(dir + "/lines.avro");
        dir.mkdirs();
        out.create(ReflectData.get().getSchema(Text.class), linesFile);
        for (String line : WordCountUtil.LINES) {
            out.append((Object)new Text(line));
        }
        out.close();
    }

    private void validateCountsFile(File file) throws Exception {
        ReflectDatumReader reader = new ReflectDatumReader();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        DataFileStream counts = new DataFileStream((InputStream)in, (DatumReader)reader);
        int numWords = 0;
        for (WordCount wc : counts) {
            Assertions.assertEquals((Long)WordCountUtil.COUNTS.get(wc.word), (Long)wc.count, (String)wc.word);
            ++numWords;
        }
        ((InputStream)in).close();
        Assertions.assertEquals((int)WordCountUtil.COUNTS.size(), (int)numWords);
    }

    public static class Text {
        private String text = "";

        public Text() {
        }

        public Text(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static class Count {
        private long count;

        public Count() {
        }

        public Count(long count) {
            this.count = count;
        }
    }

    public static class WordCount {
        private String word;
        private long count;

        public WordCount() {
        }

        public WordCount(String word, long count) {
            this.word = word;
            this.count = count;
        }
    }

    public static class MapImpl
    extends AvroMapper<Text, Pair<Text, Count>> {
        public void map(Text text, AvroCollector<Pair<Text, Count>> collector, Reporter reporter) throws IOException {
            StringTokenizer tokens = new StringTokenizer(text.toString());
            while (tokens.hasMoreTokens()) {
                collector.collect((Object)new Pair((Object)new Text(tokens.nextToken()), (Object)new Count(1L)));
            }
        }
    }

    public static class ReduceImpl
    extends AvroReducer<Text, Count, WordCount> {
        public void reduce(Text word, Iterable<Count> counts, AvroCollector<WordCount> collector, Reporter reporter) throws IOException {
            long sum = 0L;
            for (Count count : counts) {
                sum += count.count;
            }
            collector.collect((Object)new WordCount(word.text, sum));
        }
    }
}

