/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroCollector;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.AvroMultipleOutputs;
import org.apache.avro.mapred.AvroOutputFormat;
import org.apache.avro.mapred.AvroRecordReader;
import org.apache.avro.mapred.AvroReducer;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.Pair;
import org.apache.avro.mapred.WordCountUtil;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestAvroMultipleOutputs {
    @TempDir
    public File INPUT_DIR;
    @TempDir
    public File OUTPUT_DIR;

    @Test
    void runTestsInOrder() throws Exception {
        String avroPath = this.OUTPUT_DIR.getPath();
        this.testJob(avroPath);
        this.testProjection(avroPath);
        this.testProjectionNewMethodsOne(avroPath);
        this.testProjectionNewMethodsTwo(avroPath);
        this.testProjection1(avroPath);
        this.testJobNoreducer();
        this.testProjectionNoreducer(avroPath);
    }

    public void testJob(String pathOut) throws Exception {
        JobConf job = new JobConf();
        String pathIn = this.INPUT_DIR.getPath();
        File fileIn = new File(pathIn, "lines.avro");
        Path outputPath = new Path(pathOut);
        outputPath.getFileSystem((Configuration)job).delete(outputPath);
        WordCountUtil.writeLinesFile(fileIn);
        job.setJobName("AvroMultipleOutputs");
        AvroJob.setInputSchema((JobConf)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        AvroJob.setOutputSchema((JobConf)job, (Schema)new Pair((CharSequence)new Utf8(""), Long.valueOf(0L)).getSchema());
        AvroJob.setMapperClass((JobConf)job, MapImpl.class);
        AvroJob.setReducerClass((JobConf)job, ReduceImpl.class);
        FileInputFormat.setInputPaths((JobConf)job, (String)pathIn);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
        FileOutputFormat.setCompressOutput((JobConf)job, (boolean)false);
        AvroMultipleOutputs.addNamedOutput((JobConf)job, (String)"myavro", AvroOutputFormat.class, (Schema)new Pair((CharSequence)new Utf8(""), Long.valueOf(0L)).getSchema());
        AvroMultipleOutputs.addNamedOutput((JobConf)job, (String)"myavro1", AvroOutputFormat.class, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        AvroMultipleOutputs.addNamedOutput((JobConf)job, (String)"myavro2", AvroOutputFormat.class, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        WordCountUtil.setMeta(job);
        JobClient.runJob((JobConf)job);
        WordCountUtil.validateCountsFile(new File(outputPath.toString(), "/part-00000.avro"));
    }

    public void testProjection(String inputDirectory) throws Exception {
        JobConf job = new JobConf();
        Integer defaultRank = -1;
        String jsonSchema = "{\"type\":\"record\",\"name\":\"org.apache.avro.mapred.Pair\",\"fields\": [ {\"name\":\"rank\", \"type\":\"int\", \"default\": -1},{\"name\":\"value\", \"type\":\"long\"}]}";
        Schema readerSchema = Schema.parse((String)jsonSchema);
        AvroJob.setInputSchema((JobConf)job, (Schema)readerSchema);
        Path inputPath = new Path(inputDirectory + "/myavro-r-00000.avro");
        FileStatus fileStatus = FileSystem.get((Configuration)job).getFileStatus(inputPath);
        FileSplit fileSplit = new FileSplit(inputPath, 0L, fileStatus.getLen(), job);
        AvroRecordReader recordReader = new AvroRecordReader(job, fileSplit);
        AvroWrapper inputPair = new AvroWrapper(null);
        NullWritable ignore = NullWritable.get();
        long sumOfCounts = 0L;
        long numOfCounts = 0L;
        while (recordReader.next(inputPair, ignore)) {
            Assertions.assertEquals((Object)((Pair)inputPair.datum()).get(0), (Object)defaultRank);
            sumOfCounts += ((Long)((Pair)inputPair.datum()).get(1)).longValue();
            ++numOfCounts;
        }
        Assertions.assertEquals((long)numOfCounts, (long)WordCountUtil.COUNTS.size());
        long actualSumOfCounts = 0L;
        for (Long count : WordCountUtil.COUNTS.values()) {
            actualSumOfCounts += count.longValue();
        }
        Assertions.assertEquals((long)sumOfCounts, (long)actualSumOfCounts);
    }

    public void testProjectionNewMethodsOne(String inputDirectory) throws Exception {
        JobConf job = new JobConf();
        Integer defaultRank = -1;
        String jsonSchema = "{\"type\":\"record\",\"name\":\"org.apache.avro.mapred.Pair\",\"fields\": [ {\"name\":\"rank\", \"type\":\"int\", \"default\": -1},{\"name\":\"value\", \"type\":\"long\"}]}";
        Schema readerSchema = Schema.parse((String)jsonSchema);
        AvroJob.setInputSchema((JobConf)job, (Schema)readerSchema);
        Path inputPath = new Path(inputDirectory + "/testavrofile-r-00000.avro");
        FileStatus fileStatus = FileSystem.get((Configuration)job).getFileStatus(inputPath);
        FileSplit fileSplit = new FileSplit(inputPath, 0L, fileStatus.getLen(), job);
        AvroRecordReader recordReader = new AvroRecordReader(job, fileSplit);
        AvroWrapper inputPair = new AvroWrapper(null);
        NullWritable ignore = NullWritable.get();
        long sumOfCounts = 0L;
        long numOfCounts = 0L;
        while (recordReader.next(inputPair, ignore)) {
            Assertions.assertEquals((Object)((Pair)inputPair.datum()).get(0), (Object)defaultRank);
            sumOfCounts += ((Long)((Pair)inputPair.datum()).get(1)).longValue();
            ++numOfCounts;
        }
        Assertions.assertEquals((long)numOfCounts, (long)WordCountUtil.COUNTS.size());
        long actualSumOfCounts = 0L;
        for (Long count : WordCountUtil.COUNTS.values()) {
            actualSumOfCounts += count.longValue();
        }
        Assertions.assertEquals((long)sumOfCounts, (long)actualSumOfCounts);
    }

    public void testProjection1(String inputDirectory) throws Exception {
        JobConf job = new JobConf();
        Schema readerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        AvroJob.setInputSchema((JobConf)job, (Schema)readerSchema);
        Path inputPath = new Path(inputDirectory + "/myavro1-r-00000.avro");
        FileStatus fileStatus = FileSystem.get((Configuration)job).getFileStatus(inputPath);
        FileSplit fileSplit = new FileSplit(inputPath, 0L, fileStatus.getLen(), job);
        AvroWrapper inputPair = new AvroWrapper(null);
        NullWritable ignore = NullWritable.get();
        AvroRecordReader recordReader = new AvroRecordReader(job, fileSplit);
        long sumOfCounts = 0L;
        long numOfCounts = 0L;
        while (recordReader.next(inputPair, ignore)) {
            sumOfCounts += Long.parseLong(((Utf8)inputPair.datum()).toString().split(":")[2].replace("}", "").trim());
            ++numOfCounts;
        }
        Assertions.assertEquals((long)numOfCounts, (long)WordCountUtil.COUNTS.size());
        long actualSumOfCounts = 0L;
        for (Long count : WordCountUtil.COUNTS.values()) {
            actualSumOfCounts += count.longValue();
        }
        Assertions.assertEquals((long)sumOfCounts, (long)actualSumOfCounts);
    }

    public void testProjectionNewMethodsTwo(String inputDirectory) throws Exception {
        JobConf job = new JobConf();
        Schema readerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        AvroJob.setInputSchema((JobConf)job, (Schema)readerSchema);
        Path inputPath = new Path(inputDirectory + "/testavrofile1-r-00000.avro");
        FileStatus fileStatus = FileSystem.get((Configuration)job).getFileStatus(inputPath);
        FileSplit fileSplit = new FileSplit(inputPath, 0L, fileStatus.getLen(), job);
        AvroWrapper inputPair = new AvroWrapper(null);
        NullWritable ignore = NullWritable.get();
        AvroRecordReader recordReader = new AvroRecordReader(job, fileSplit);
        long sumOfCounts = 0L;
        long numOfCounts = 0L;
        while (recordReader.next(inputPair, ignore)) {
            sumOfCounts += Long.parseLong(((Utf8)inputPair.datum()).toString().split(":")[2].replace("}", "").trim());
            ++numOfCounts;
        }
        Assertions.assertEquals((long)numOfCounts, (long)WordCountUtil.COUNTS.size());
        long actualSumOfCounts = 0L;
        for (Long count : WordCountUtil.COUNTS.values()) {
            actualSumOfCounts += count.longValue();
        }
        Assertions.assertEquals((long)sumOfCounts, (long)actualSumOfCounts);
    }

    public void testJobNoreducer() throws Exception {
        JobConf job = new JobConf();
        job.setNumReduceTasks(0);
        Path outputPath = new Path(this.OUTPUT_DIR.getPath());
        outputPath.getFileSystem((Configuration)job).delete(outputPath, true);
        WordCountUtil.writeLinesFile(new File(this.INPUT_DIR, "lines.avro"));
        job.setJobName("AvroMultipleOutputs_noreducer");
        AvroJob.setInputSchema((JobConf)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        AvroJob.setOutputSchema((JobConf)job, (Schema)new Pair((CharSequence)new Utf8(""), Long.valueOf(0L)).getSchema());
        AvroJob.setMapperClass((JobConf)job, MapImpl.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(this.INPUT_DIR.toString())});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
        FileOutputFormat.setCompressOutput((JobConf)job, (boolean)false);
        AvroMultipleOutputs.addNamedOutput((JobConf)job, (String)"myavro2", AvroOutputFormat.class, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        JobClient.runJob((JobConf)job);
    }

    public void testProjectionNoreducer(String inputDirectory) throws Exception {
        JobConf job = new JobConf();
        long onel = 1L;
        Schema readerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        AvroJob.setInputSchema((JobConf)job, (Schema)readerSchema);
        Path inputPath = new Path(inputDirectory + "/myavro2-m-00000.avro");
        FileStatus fileStatus = FileSystem.get((Configuration)job).getFileStatus(inputPath);
        FileSplit fileSplit = new FileSplit(inputPath, 0L, fileStatus.getLen(), (String[])null);
        AvroRecordReader recordReader = new AvroRecordReader(job, fileSplit);
        AvroWrapper inputPair = new AvroWrapper(null);
        NullWritable ignore = NullWritable.get();
        while (recordReader.next(inputPair, ignore)) {
            long testl = Long.parseLong(((Utf8)inputPair.datum()).toString().split(":")[2].replace("}", "").trim());
            Assertions.assertEquals((long)onel, (long)testl);
        }
    }

    public static class MapImpl
    extends AvroMapper<Utf8, Pair<Utf8, Long>> {
        private AvroMultipleOutputs amos;

        public void configure(JobConf Job2) {
            this.amos = new AvroMultipleOutputs(Job2);
        }

        public void map(Utf8 text, AvroCollector<Pair<Utf8, Long>> collector, Reporter reporter) throws IOException {
            StringTokenizer tokens = new StringTokenizer(text.toString());
            while (tokens.hasMoreTokens()) {
                String tok = tokens.nextToken();
                collector.collect((Object)new Pair((CharSequence)new Utf8(tok), Long.valueOf(1L)));
                this.amos.getCollector("myavro2", reporter).collect((Object)new Pair((CharSequence)new Utf8(tok), Long.valueOf(1L)).toString());
            }
        }

        public void close() throws IOException {
            this.amos.close();
        }
    }

    public static class ReduceImpl
    extends AvroReducer<Utf8, Long, Pair<Utf8, Long>> {
        private AvroMultipleOutputs amos;

        public void configure(JobConf Job2) {
            this.amos = new AvroMultipleOutputs(Job2);
        }

        public void reduce(Utf8 word, Iterable<Long> counts, AvroCollector<Pair<Utf8, Long>> collector, Reporter reporter) throws IOException {
            long sum = 0L;
            for (long count : counts) {
                sum += count;
            }
            Pair outputvalue = new Pair((CharSequence)word, Long.valueOf(sum));
            this.amos.getCollector("myavro", reporter).collect((Object)outputvalue);
            this.amos.collect("myavro1", reporter, (Object)outputvalue.toString());
            this.amos.collect("myavro", reporter, new Pair((CharSequence)new Utf8(""), Long.valueOf(0L)).getSchema(), (Object)outputvalue, "testavrofile");
            this.amos.collect("myavro", reporter, Schema.create((Schema.Type)Schema.Type.STRING), (Object)outputvalue.toString(), "testavrofile1");
            collector.collect((Object)new Pair((CharSequence)word, Long.valueOf(sum)));
        }

        public void close() throws IOException {
            this.amos.close();
        }
    }
}

