/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.netty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.netty.NettyServer;
import org.apache.avro.ipc.netty.NettyTransceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.test.Simple;
import org.apache.avro.test.TestError;
import org.apache.avro.test.TestRecord;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestNettyServerConcurrentExecution {
    private Server server;
    private Transceiver transceiver;

    @AfterEach
    public void cleanUpAfter() throws Exception {
        try {
            if (this.transceiver != null) {
                this.transceiver.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    @Timeout(value=30000L)
    void test() throws Exception {
        final CountDownLatch waitLatch = new CountDownLatch(1);
        this.server = new NettyServer((Responder)new SpecificResponder(Simple.class, (Object)new SimpleImpl(waitLatch)), new InetSocketAddress(0));
        this.server.start();
        this.transceiver = new NettyTransceiver(new InetSocketAddress(this.server.getPort()), Integer.valueOf(2000));
        final Simple.Callback simpleClient = (Simple.Callback)SpecificRequestor.getClient(Simple.Callback.class, (Transceiver)this.transceiver);
        SpecificRequestor.getRemote((Object)simpleClient);
        new Thread(){

            @Override
            public void run() {
                this.setName(TestNettyServerConcurrentExecution.class.getSimpleName() + "Ack Thread");
                try {
                    waitLatch.await();
                    simpleClient.ack();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        String response = simpleClient.hello("wait");
        Assertions.assertEquals((Object)"wait", (Object)response);
        Thread.sleep(2000L);
    }

    private static class SimpleImpl
    implements Simple {
        private final CountDownLatch waitLatch;
        private final CountDownLatch ackLatch = new CountDownLatch(1);

        public SimpleImpl(CountDownLatch waitLatch) {
            this.waitLatch = waitLatch;
        }

        public int add(int arg1, int arg2) {
            System.out.println("Adding " + arg1 + "+" + arg2);
            return arg1 + arg2;
        }

        public String hello(String greeting) {
            if (greeting.equals("wait")) {
                try {
                    this.waitLatch.countDown();
                    this.ackLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return e.toString();
                }
            }
            return greeting;
        }

        public void ack() {
            this.ackLatch.countDown();
        }

        public TestRecord echo(TestRecord record) {
            return record;
        }

        public ByteBuffer echoBytes(ByteBuffer data) {
            return data;
        }

        public void error() throws TestError {
            throw new TestError((Object)"TestError");
        }
    }
}

