/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.netty;

import io.netty.channel.socket.SocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.apache.avro.ipc.netty.NettyTransceiver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNettyTransceiverWhenFailsToConnect {
    SocketChannel channel = null;

    @Test
    void nettyTransceiverReleasesNettyChannelOnFailingToConnect() throws Exception {
        Assertions.assertThrows(IOException.class, () -> {
            try (ServerSocket serverSocket = new ServerSocket(0);
                 NettyTransceiver t = new NettyTransceiver(new InetSocketAddress(serverSocket.getLocalPort()), Integer.valueOf(0), c -> {
                this.channel = c;
            });){
                Assertions.fail((String)"should have thrown an exception");
            }
            catch (Throwable throwable) {
                Assertions.assertTrue((this.channel == null || this.channel.isShutdown() ? 1 : 0) != 0, (String)"Channel not shut down");
                throw throwable;
            }
            Assertions.assertTrue((this.channel == null || this.channel.isShutdown() ? 1 : 0) != 0, (String)"Channel not shut down");
        });
    }
}

