/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.netty;

import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.avro.ipc.netty.TestNettyServer;
import org.junit.jupiter.api.BeforeAll;

public class TestNettyServerWithSSL
extends TestNettyServer {
    private static final String TEST_CERTIFICATE = "servercert.p12";
    private static final String TEST_CERTIFICATE_FILEPASS = "serverpass.txt";

    @BeforeAll
    public static void initializeConnections() throws Exception {
        TestNettyServerWithSSL.initializeConnections(ch -> {
            SSLEngine sslEngine = TestNettyServerWithSSL.createServerSSLContext().createSSLEngine();
            sslEngine.setUseClientMode(false);
            SslHandler handler = new SslHandler(sslEngine, false);
            ch.pipeline().addLast("SSL", (ChannelHandler)handler);
        }, ch -> {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new BogusTrustManager()}, null);
                SSLEngine sslEngine = sslContext.createSSLEngine();
                sslEngine.setUseClientMode(true);
                SslHandler handler = new SslHandler(sslEngine, false);
                ch.pipeline().addLast("SSL", (ChannelHandler)handler);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static SSLContext createServerSSLContext() {
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(TestNettyServer.class.getResource(TEST_CERTIFICATE).openStream(), TestNettyServerWithSSL.getPass());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(TestNettyServerWithSSL.getAlgorithm());
            kmf.init(ks, TestNettyServerWithSSL.getPass());
            SSLContext serverContext = SSLContext.getInstance("TLS");
            serverContext.init(kmf.getKeyManagers(), null, null);
            return serverContext;
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the server-side SSLContext", e);
        }
    }

    private static char[] getPass() {
        File passFile = new File(TestNettyServer.class.getResource(TEST_CERTIFICATE_FILEPASS).getPath());
        try {
            String pass = Files.readAllLines(passFile.toPath()).get(0);
            return pass.toCharArray();
        }
        catch (IOException e) {
            throw new Error("Failed to open pass file", e);
        }
    }

    private static String getAlgorithm() {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        return algorithm;
    }

    private static class BogusTrustManager
    implements X509TrustManager {
        private BogusTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

