/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Objects;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.idl.IdlFile;
import org.apache.avro.idl.IdlReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCycle {
    private static final Logger LOG = LoggerFactory.getLogger(TestCycle.class);

    @Test
    public void testCycleGeneration() throws IOException, URISyntaxException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        IdlReader parser = new IdlReader();
        IdlFile idlFile = parser.parse(Objects.requireNonNull(cl.getResource("input/cycle.avdl")).toURI());
        String json = idlFile.outputString();
        LOG.info(json);
        GenericRecordBuilder rb2 = new GenericRecordBuilder(idlFile.getNamedSchema("org.apache.avro.gen.SampleNode"));
        rb2.set("count", (Object)10);
        rb2.set("subNodes", (Object)Collections.EMPTY_LIST);
        GenericData.Record node = rb2.build();
        GenericRecordBuilder mb = new GenericRecordBuilder(idlFile.getNamedSchema("org.apache.avro.gen.Method"));
        mb.set("declaringClass", (Object)"Test");
        mb.set("methodName", (Object)"test");
        GenericData.Record method = mb.build();
        GenericRecordBuilder spb = new GenericRecordBuilder(idlFile.getNamedSchema("org.apache.avro.gen.SamplePair"));
        spb.set("method", (Object)method);
        spb.set("node", (Object)node);
        GenericData.Record sp = spb.build();
        GenericRecordBuilder rb = new GenericRecordBuilder(idlFile.getNamedSchema("org.apache.avro.gen.SampleNode"));
        rb.set("count", (Object)10);
        rb.set("subNodes", Collections.singletonList(sp));
        GenericData.Record record = rb.build();
        TestCycle.serDeserRecord(record);
    }

    private static void serDeserRecord(GenericData.Record data) throws IOException {
        ByteArrayOutputStream bab = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(data.getSchema());
        BinaryEncoder directBinaryEncoder = EncoderFactory.get().directBinaryEncoder((OutputStream)bab, null);
        writer.write((Object)data, (Encoder)directBinaryEncoder);
        directBinaryEncoder.flush();
        ByteArrayInputStream bis = new ByteArrayInputStream(bab.toByteArray(), 0, bab.size());
        GenericDatumReader reader = new GenericDatumReader(data.getSchema());
        BinaryDecoder directBinaryDecoder = DecoderFactory.get().directBinaryDecoder((InputStream)bis, null);
        GenericData.Record read = (GenericData.Record)reader.read(null, (Decoder)directBinaryDecoder);
        Assert.assertEquals((Object)data.toString(), (Object)read.toString());
    }
}

