/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.avro.JsonProperties;
import org.apache.avro.JsonSchemaParser;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.ParseContext;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.idl.IdlBaseListener;
import org.apache.avro.idl.IdlFile;
import org.apache.avro.idl.IdlLexer;
import org.apache.avro.idl.IdlParser;
import org.apache.avro.util.SchemaResolver;
import org.apache.avro.util.UtfTextUtils;
import org.apache.avro.util.internal.Accessor;
import org.apache.commons.text.StringEscapeUtils;

public class IdlReader {
    private static final BaseErrorListener SIMPLE_AVRO_ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new SchemaParseException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    };
    private static final String OPTIONAL_NULLABLE_TYPE_PROPERTY = "org.apache.avro.idl.Idl.NullableType.optional";
    private static final Pattern WS_INDENT = Pattern.compile("(?U).*\\R(?<indent>\\h*).*(?:\\R\\k<indent>.*)*");
    private static final Pattern STAR_INDENT = Pattern.compile("(?U)(?<stars>\\*{1,2}).*(?:\\R\\h*\\k<stars>.*)*");
    private static final Predicate<String> VALID_NAME = Pattern.compile("[_\\p{L}][_\\p{LD}]*", 448).asPredicate();
    private static final Set<String> INVALID_TYPE_NAMES = new HashSet<String>(Arrays.asList("boolean", "int", "long", "float", "double", "bytes", "string", "null", "date", "time_ms", "timestamp_ms", "localtimestamp_ms", "uuid"));
    private static final String CLASSPATH_SCHEME = "classpath";
    private static final Set<Schema.Type> NAMED_SCHEMA_TYPES = EnumSet.of(Schema.Type.RECORD, Schema.Type.ENUM, Schema.Type.FIXED);
    private final Set<URI> readLocations = new HashSet<URI>();
    private final ParseContext parseContext;

    public IdlReader() {
        this(new ParseContext());
    }

    public IdlReader(ParseContext parseContext) {
        this.parseContext = parseContext;
    }

    private Schema namedSchemaOrUnresolved(String fullName) {
        return this.parseContext.find(fullName, null);
    }

    private void addSchema(Schema schema) {
        this.parseContext.put(schema);
    }

    public IdlFile parse(Path location) throws IOException {
        return this.parse(location.toUri());
    }

    IdlFile parse(URI location) throws IOException {
        this.readLocations.add(location);
        URI inputDir = location;
        if ("jar".equals(location.getScheme())) {
            String jarUriAsString = location.toString();
            String pathFromJarRoot = jarUriAsString.substring(jarUriAsString.indexOf("!/") + 2);
            inputDir = URI.create("classpath:/" + pathFromJarRoot);
        }
        inputDir = inputDir.resolve(".");
        try (InputStream stream = location.toURL().openStream();){
            String inputString = UtfTextUtils.readAllBytes((InputStream)stream, null);
            IdlFile idlFile = this.parse(inputDir, (CharStream)CharStreams.fromString((String)inputString));
            return idlFile;
        }
    }

    public IdlFile parse(URI directory, CharSequence source) throws IOException {
        return this.parse(directory, (CharStream)CharStreams.fromString((String)source.toString()));
    }

    public IdlFile parse(InputStream stream) throws IOException {
        return this.parse(null, CharStreams.fromStream((InputStream)stream, (Charset)StandardCharsets.UTF_8));
    }

    private IdlFile parse(URI inputDir, CharStream charStream) {
        IdlLexer lexer = new IdlLexer(charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        IdlParserListener parseListener = new IdlParserListener(inputDir, tokenStream);
        IdlParser parser = new IdlParser((TokenStream)tokenStream);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)SIMPLE_AVRO_ERROR_LISTENER);
        parser.addParseListener(parseListener);
        parser.setTrace(false);
        parser.setBuildParseTree(false);
        try {
            parser.idlFile();
        }
        catch (SchemaParseException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new SchemaParseException((Throwable)e);
        }
        return parseListener.getIdlFile();
    }

    static String stripIndents(String docComment) {
        Matcher starMatcher = STAR_INDENT.matcher(docComment);
        if (starMatcher.matches()) {
            return docComment.replaceAll("(?U)(?:^|(\\R)\\h*)\\Q" + starMatcher.group("stars") + "\\E\\h?", "$1");
        }
        Matcher whitespaceMatcher = WS_INDENT.matcher(docComment);
        if (whitespaceMatcher.matches()) {
            return docComment.replaceAll("(?U)(\\R)" + whitespaceMatcher.group("indent"), "$1");
        }
        return docComment;
    }

    private static SchemaParseException error(String message, Token token) {
        return IdlReader.error(message, token, null);
    }

    private static SchemaParseException error(String message, Token token, Throwable cause) {
        SchemaParseException exception = new SchemaParseException(message + ", at line " + token.getLine() + ", column " + token.getCharPositionInLine());
        if (cause != null) {
            exception.initCause(cause);
        }
        return exception;
    }

    private class IdlParserListener
    extends IdlBaseListener {
        private final URI inputDir;
        private final CommonTokenStream tokenStream;
        private int hiddenTokensProcessedIndex;
        private final List<String> warnings;
        private IdlFile result;
        private Schema mainSchema;
        private Protocol protocol;
        private final Deque<String> namespaces;
        private final List<String> enumSymbols;
        private String enumDefaultSymbol;
        private Schema schema;
        private String defaultVariableDocComment;
        private final List<Schema.Field> fields;
        private final Deque<Schema> typeStack;
        private final Deque<JsonNode> jsonValues;
        private final Deque<SchemaProperties> propertiesStack;
        private String messageDocComment;

        public IdlParserListener(URI inputDir, CommonTokenStream tokenStream) {
            this.inputDir = inputDir;
            this.tokenStream = tokenStream;
            this.hiddenTokensProcessedIndex = -1;
            this.warnings = new ArrayList<String>();
            this.result = null;
            this.mainSchema = null;
            this.protocol = null;
            this.namespaces = new ArrayDeque<String>();
            this.enumSymbols = new ArrayList<String>();
            this.enumDefaultSymbol = null;
            this.schema = null;
            this.defaultVariableDocComment = null;
            this.fields = new ArrayList<Schema.Field>();
            this.typeStack = new ArrayDeque<Schema>();
            this.propertiesStack = new ArrayDeque<SchemaProperties>();
            this.jsonValues = new ArrayDeque<JsonNode>();
            this.messageDocComment = null;
        }

        public IdlFile getIdlFile() {
            return this.result;
        }

        private String getDocComment(ParserRuleContext ctx) {
            List hiddenTokens;
            int newHiddenTokensProcessedIndex = ctx.start.getTokenIndex();
            List docCommentTokens = this.tokenStream.getHiddenTokensToLeft(newHiddenTokensProcessedIndex, -1);
            int searchEndIndex = newHiddenTokensProcessedIndex;
            Token docCommentToken = null;
            if (docCommentTokens != null) {
                docCommentToken = (Token)docCommentTokens.get(docCommentTokens.size() - 1);
                searchEndIndex = docCommentToken.getTokenIndex() - 1;
            }
            Set<Integer> allHiddenTokens = Collections.singleton(2);
            if (searchEndIndex >= 0 && (hiddenTokens = this.tokenStream.getTokens(this.hiddenTokensProcessedIndex + 1, searchEndIndex, allHiddenTokens)) != null) {
                for (Token token : hiddenTokens) {
                    this.warnings.add(String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", token.getLine(), token.getCharPositionInLine() + 1));
                }
            }
            this.hiddenTokensProcessedIndex = newHiddenTokensProcessedIndex;
            if (docCommentToken == null) {
                return null;
            }
            String comment = docCommentToken.getText();
            String text = comment.substring(3, comment.length() - 2);
            return IdlReader.stripIndents(text.trim());
        }

        private void pushNamespace(String namespace) {
            this.namespaces.push(namespace == null ? "" : namespace);
        }

        private String currentNamespace() {
            String namespace = this.namespaces.peek();
            return namespace == null || namespace.isEmpty() ? null : namespace;
        }

        private void popNamespace() {
            this.namespaces.pop();
        }

        @Override
        public void exitIdlFile(IdlParser.IdlFileContext ctx) {
            this.result = this.protocol == null ? new IdlFile(this.mainSchema, IdlReader.this.parseContext, this.warnings) : new IdlFile(this.protocol, IdlReader.this.parseContext, this.warnings);
        }

        @Override
        public void enterProtocolDeclaration(IdlParser.ProtocolDeclarationContext ctx) {
            this.propertiesStack.push(new SchemaProperties(null, true, false, false));
        }

        @Override
        public void enterProtocolDeclarationBody(IdlParser.ProtocolDeclarationBodyContext ctx) {
            IdlParser.ProtocolDeclarationContext protocolCtx = (IdlParser.ProtocolDeclarationContext)ctx.parent;
            SchemaProperties properties = this.propertiesStack.pop();
            String protocolIdentifier = this.identifier(protocolCtx.name);
            this.pushNamespace(this.namespace(protocolIdentifier, properties.namespace()));
            String protocolName = this.name(protocolIdentifier);
            String docComment = this.getDocComment(protocolCtx);
            String protocolNamespace = this.currentNamespace();
            this.protocol = properties.copyProperties(new Protocol(protocolName, docComment, protocolNamespace));
        }

        @Override
        public void exitProtocolDeclaration(IdlParser.ProtocolDeclarationContext ctx) {
            if (this.protocol != null) {
                IdlReader.this.parseContext.commit();
                this.protocol.setTypes((Collection)IdlReader.this.parseContext.resolveAllSchemas());
            }
            if (!this.namespaces.isEmpty()) {
                this.popNamespace();
            }
        }

        @Override
        public void exitNamespaceDeclaration(IdlParser.NamespaceDeclarationContext ctx) {
            this.pushNamespace(this.namespace("", this.identifier(ctx.namespace)));
        }

        @Override
        public void exitMainSchemaDeclaration(IdlParser.MainSchemaDeclarationContext ctx) {
            this.mainSchema = this.typeStack.pop();
            if (NAMED_SCHEMA_TYPES.contains(this.mainSchema.getType()) && this.mainSchema.getFullName() != null) {
                IdlReader.this.parseContext.put(this.mainSchema);
            }
            assert (this.typeStack.isEmpty());
        }

        @Override
        public void enterSchemaProperty(IdlParser.SchemaPropertyContext ctx) {
            assert (this.jsonValues.isEmpty());
        }

        @Override
        public void exitSchemaProperty(IdlParser.SchemaPropertyContext ctx) {
            String name = this.identifier(ctx.name);
            JsonNode value = this.jsonValues.pop();
            Token firstToken = ctx.value.start;
            this.propertiesStack.element().addProperty(name, value, firstToken);
            super.exitSchemaProperty(ctx);
        }

        @Override
        public void exitImportStatement(IdlParser.ImportStatementContext importContext) {
            String importFile = this.getString(importContext.location);
            try {
                URI importLocation = this.findImport(importFile);
                if (!IdlReader.this.readLocations.add(importLocation)) {
                    return;
                }
                switch (importContext.importType.getType()) {
                    case 10: {
                        IdlFile idlFile = IdlReader.this.parse(importLocation);
                        if (this.protocol != null && idlFile.getProtocol() != null) {
                            this.protocol.getMessages().putAll(idlFile.getProtocol().getMessages());
                        }
                        this.warnings.addAll(idlFile.getWarnings(importFile));
                        break;
                    }
                    case 7: {
                        try (InputStream stream = importLocation.toURL().openStream();){
                            Protocol importProtocol = Protocol.parse((InputStream)stream);
                            for (Schema s : importProtocol.getTypes()) {
                                IdlReader.this.addSchema(s);
                            }
                            if (this.protocol != null) {
                                this.protocol.getMessages().putAll(importProtocol.getMessages());
                            }
                            break;
                        }
                    }
                    case 11: {
                        InputStream stream = importLocation.toURL().openStream();
                        try {
                            JsonSchemaParser parser = new JsonSchemaParser();
                            parser.parse(IdlReader.this.parseContext, importLocation.resolve("."), (CharSequence)UtfTextUtils.readAllBytes((InputStream)stream, null));
                            if (stream == null) break;
                        }
                        catch (Throwable throwable) {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stream.close();
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw IdlReader.error("Error importing " + importFile + ": " + e, importContext.location, e);
            }
        }

        private URI findImport(String importFile) throws IOException {
            String resourceName;
            URI resourceLocation;
            URI importLocation = this.inputDir.resolve(importFile);
            String importLocationScheme = importLocation.getScheme();
            if (IdlReader.CLASSPATH_SCHEME.equals(importLocationScheme) && (resourceLocation = this.findResource(resourceName = importLocation.getSchemeSpecificPart().substring(1))) != null) {
                return resourceLocation;
            }
            if ("file".equals(importLocationScheme) && Files.exists(Paths.get(importLocation), new LinkOption[0])) {
                return importLocation;
            }
            URI resourceLocation2 = this.findResource(importFile);
            if (resourceLocation2 != null) {
                return resourceLocation2;
            }
            throw new FileNotFoundException(importFile);
        }

        private URI findResource(String resourceName) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resourceLocation = classLoader == null ? ClassLoader.getSystemResource(resourceName) : classLoader.getResource(resourceName);
            return resourceLocation == null ? null : URI.create(resourceLocation.toExternalForm());
        }

        @Override
        public void enterFixedDeclaration(IdlParser.FixedDeclarationContext ctx) {
            this.propertiesStack.push(new SchemaProperties(this.currentNamespace(), true, true, false));
        }

        @Override
        public void exitFixedDeclaration(IdlParser.FixedDeclarationContext ctx) {
            SchemaProperties properties = this.propertiesStack.pop();
            String doc = this.getDocComment(ctx);
            String identifier = this.identifier(ctx.name);
            String name = this.name(identifier);
            String space = this.namespace(identifier, properties.namespace());
            int size = Integer.decode(ctx.size.getText());
            Schema schema = Schema.createFixed((String)name, (String)doc, (String)space, (int)size);
            properties.copyAliases(arg_0 -> ((Schema)schema).addAlias(arg_0));
            properties.copyProperties(schema);
            IdlReader.this.addSchema(schema);
        }

        @Override
        public void enterEnumDeclaration(IdlParser.EnumDeclarationContext ctx) {
            assert (this.enumSymbols.isEmpty());
            assert (this.enumDefaultSymbol == null);
            this.propertiesStack.push(new SchemaProperties(this.currentNamespace(), true, true, false));
        }

        @Override
        public void exitEnumDeclaration(IdlParser.EnumDeclarationContext ctx) {
            String doc = this.getDocComment(ctx);
            SchemaProperties properties = this.propertiesStack.pop();
            String identifier = this.identifier(ctx.name);
            String name = this.name(identifier);
            String space = this.namespace(identifier, properties.namespace());
            Schema schema = Schema.createEnum((String)name, (String)doc, (String)space, new ArrayList<String>(this.enumSymbols), (String)this.enumDefaultSymbol);
            properties.copyAliases(arg_0 -> ((Schema)schema).addAlias(arg_0));
            properties.copyProperties(schema);
            this.enumSymbols.clear();
            this.enumDefaultSymbol = null;
            IdlReader.this.addSchema(schema);
        }

        @Override
        public void enterEnumSymbol(IdlParser.EnumSymbolContext ctx) {
            this.propertiesStack.push(new SchemaProperties(null, false, false, false));
        }

        @Override
        public void exitEnumSymbol(IdlParser.EnumSymbolContext ctx) {
            this.propertiesStack.pop();
            this.enumSymbols.add(this.identifier(ctx.name));
        }

        @Override
        public void exitEnumDefault(IdlParser.EnumDefaultContext ctx) {
            this.enumDefaultSymbol = this.identifier(ctx.defaultSymbolName);
        }

        @Override
        public void enterRecordDeclaration(IdlParser.RecordDeclarationContext ctx) {
            assert (this.schema == null);
            assert (this.fields.isEmpty());
            this.propertiesStack.push(new SchemaProperties(this.currentNamespace(), true, true, false));
        }

        @Override
        public void enterRecordBody(IdlParser.RecordBodyContext ctx) {
            assert (this.fields.isEmpty());
            IdlParser.RecordDeclarationContext recordCtx = (IdlParser.RecordDeclarationContext)ctx.parent;
            SchemaProperties properties = this.propertiesStack.pop();
            String doc = this.getDocComment(recordCtx);
            String identifier = this.identifier(recordCtx.name);
            String name = this.name(identifier);
            this.pushNamespace(this.namespace(identifier, properties.namespace()));
            boolean isError = recordCtx.recordType.getType() == 14;
            this.schema = Schema.createRecord((String)name, (String)doc, (String)this.currentNamespace(), (boolean)isError);
            properties.copyAliases(arg_0 -> ((Schema)this.schema).addAlias(arg_0));
            properties.copyProperties(this.schema);
        }

        @Override
        public void exitRecordDeclaration(IdlParser.RecordDeclarationContext ctx) {
            this.schema.setFields(this.fields);
            this.fields.clear();
            IdlReader.this.addSchema(this.schema);
            this.schema = null;
            this.popNamespace();
        }

        @Override
        public void enterFieldDeclaration(IdlParser.FieldDeclarationContext ctx) {
            assert (this.typeStack.isEmpty());
            this.defaultVariableDocComment = this.getDocComment(ctx);
        }

        @Override
        public void exitFieldDeclaration(IdlParser.FieldDeclarationContext ctx) {
            this.typeStack.pop();
            this.defaultVariableDocComment = null;
        }

        @Override
        public void enterVariableDeclaration(IdlParser.VariableDeclarationContext ctx) {
            assert (this.jsonValues.isEmpty());
            this.propertiesStack.push(new SchemaProperties(this.currentNamespace(), false, true, true));
        }

        @Override
        public void exitVariableDeclaration(IdlParser.VariableDeclarationContext ctx) {
            String doc = Optional.ofNullable(this.getDocComment(ctx)).orElse(this.defaultVariableDocComment);
            String fieldName = this.identifier(ctx.fieldName);
            JsonNode defaultValue = this.jsonValues.poll();
            Schema type = this.typeStack.element();
            JsonNode fieldDefault = this.fixDefaultValue(defaultValue, type);
            Schema fieldType = this.fixOptionalSchema(type, fieldDefault);
            SchemaProperties properties = this.propertiesStack.pop();
            boolean validate = SchemaResolver.isFullyResolvedSchema((Schema)fieldType);
            Schema.Field field = Accessor.createField((String)fieldName, (Schema)fieldType, (String)doc, (JsonNode)fieldDefault, (boolean)validate, (Schema.Field.Order)properties.order());
            properties.copyAliases(arg_0 -> ((Schema.Field)field).addAlias(arg_0));
            properties.copyProperties(field);
            this.fields.add(field);
        }

        private JsonNode fixDefaultValue(JsonNode defaultValue, Schema fieldType) {
            if (!(defaultValue instanceof IntNode)) {
                return defaultValue;
            }
            if (fieldType.getType() == Schema.Type.UNION) {
                Schema unionedType;
                Iterator iterator = fieldType.getTypes().iterator();
                while (iterator.hasNext() && (unionedType = (Schema)iterator.next()).getType() != Schema.Type.INT) {
                    if (unionedType.getType() != Schema.Type.LONG) continue;
                    return new LongNode(defaultValue.longValue());
                }
                return defaultValue;
            }
            if (fieldType.getType() == Schema.Type.LONG) {
                return new LongNode(defaultValue.longValue());
            }
            return defaultValue;
        }

        private Schema fixOptionalSchema(Schema schema, JsonNode defaultValue) {
            boolean nonNullDefault;
            Object optionalType = schema.getObjectProp(IdlReader.OPTIONAL_NULLABLE_TYPE_PROPERTY);
            if (optionalType == null) {
                return schema;
            }
            Schema nullSchema = (Schema)schema.getTypes().get(0);
            Schema nonNullSchema = (Schema)schema.getTypes().get(1);
            boolean bl = nonNullDefault = defaultValue != null && !defaultValue.isNull();
            if (nonNullDefault) {
                return Schema.createUnion((Schema[])new Schema[]{nonNullSchema, nullSchema});
            }
            return Schema.createUnion((Schema[])new Schema[]{nullSchema, nonNullSchema});
        }

        @Override
        public void enterMessageDeclaration(IdlParser.MessageDeclarationContext ctx) {
            assert (this.typeStack.isEmpty());
            assert (this.fields.isEmpty());
            assert (this.messageDocComment == null);
            this.propertiesStack.push(new SchemaProperties(this.currentNamespace(), false, false, false));
            this.messageDocComment = this.getDocComment(ctx);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void exitMessageDeclaration(IdlParser.MessageDeclarationContext ctx) {
            Protocol.Message message;
            Schema resultType = this.typeStack.pop();
            Map<String, JsonNode> properties = this.propertiesStack.pop().properties;
            String name = this.identifier(ctx.name);
            Schema request = Schema.createRecord(null, null, null, (boolean)false, this.fields);
            this.fields.clear();
            if (ctx.oneway != null) {
                if (resultType.getType() != Schema.Type.NULL) throw IdlReader.error("One-way message'" + name + "' must return void", ctx.returnType.start);
                message = this.protocol.createMessage(name, this.messageDocComment, properties, request);
            } else {
                ArrayList<Schema> errorSchemas = new ArrayList<Schema>();
                errorSchemas.add(Protocol.SYSTEM_ERROR);
                for (IdlParser.IdentifierContext errorContext : ctx.errors) {
                    errorSchemas.add(IdlReader.this.namedSchemaOrUnresolved(this.fullName(this.currentNamespace(), this.identifier(errorContext))));
                }
                message = this.protocol.createMessage(name, this.messageDocComment, properties, request, resultType, Schema.createUnion(errorSchemas));
            }
            this.messageDocComment = null;
            this.protocol.getMessages().put(message.getName(), message);
        }

        @Override
        public void enterFormalParameter(IdlParser.FormalParameterContext ctx) {
            assert (this.typeStack.size() == 1);
            this.defaultVariableDocComment = this.getDocComment(ctx);
        }

        @Override
        public void exitFormalParameter(IdlParser.FormalParameterContext ctx) {
            this.typeStack.pop();
            this.defaultVariableDocComment = null;
        }

        @Override
        public void exitResultType(IdlParser.ResultTypeContext ctx) {
            if (this.typeStack.isEmpty()) {
                this.typeStack.push(Schema.create((Schema.Type)Schema.Type.NULL));
            }
        }

        @Override
        public void enterFullType(IdlParser.FullTypeContext ctx) {
            this.propertiesStack.push(new SchemaProperties(this.currentNamespace(), false, false, false));
        }

        @Override
        public void exitFullType(IdlParser.FullTypeContext ctx) {
            SchemaProperties properties = this.propertiesStack.pop();
            Schema type = this.typeStack.element();
            if (type.getObjectProp(IdlReader.OPTIONAL_NULLABLE_TYPE_PROPERTY) != null) {
                properties.copyProperties((Schema)type.getTypes().get(1));
            } else {
                properties.copyProperties(type);
            }
        }

        @Override
        public void exitNullableType(IdlParser.NullableTypeContext ctx) {
            Schema type;
            if (ctx.referenceName == null) {
                type = this.typeStack.pop();
            } else {
                if (this.propertiesStack.isEmpty() || this.propertiesStack.peek().hasProperties()) {
                    throw IdlReader.error("Type references may not be annotated", ctx.getParent().getStart());
                }
                type = IdlReader.this.namedSchemaOrUnresolved(this.fullName(this.currentNamespace(), this.identifier(ctx.referenceName)));
            }
            if (ctx.optional != null) {
                type = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), type});
                type.addProp(IdlReader.OPTIONAL_NULLABLE_TYPE_PROPERTY, (Object)BooleanNode.TRUE);
            }
            this.typeStack.push(type);
        }

        @Override
        public void exitPrimitiveType(IdlParser.PrimitiveTypeContext ctx) {
            switch (ctx.typeName.getType()) {
                case 19: {
                    this.typeStack.push(Schema.create((Schema.Type)Schema.Type.BOOLEAN));
                    break;
                }
                case 20: {
                    this.typeStack.push(Schema.create((Schema.Type)Schema.Type.INT));
                    break;
                }
                case 21: {
                    this.typeStack.push(Schema.create((Schema.Type)Schema.Type.LONG));
                    break;
                }
                case 22: {
                    this.typeStack.push(Schema.create((Schema.Type)Schema.Type.FLOAT));
                    break;
                }
                case 23: {
                    this.typeStack.push(Schema.create((Schema.Type)Schema.Type.DOUBLE));
                    break;
                }
                case 25: {
                    this.typeStack.push(Schema.create((Schema.Type)Schema.Type.BYTES));
                    break;
                }
                case 24: {
                    this.typeStack.push(Schema.create((Schema.Type)Schema.Type.STRING));
                    break;
                }
                case 26: {
                    this.typeStack.push(Schema.create((Schema.Type)Schema.Type.NULL));
                    break;
                }
                case 30: {
                    this.typeStack.push(LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT)));
                    break;
                }
                case 31: {
                    this.typeStack.push(LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT)));
                    break;
                }
                case 32: {
                    this.typeStack.push(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)));
                    break;
                }
                case 33: {
                    this.typeStack.push(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)));
                    break;
                }
                case 34: {
                    this.typeStack.push(LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING)));
                    break;
                }
                default: {
                    int precision = Integer.decode(ctx.precision.getText());
                    int scale = ctx.scale == null ? 0 : Integer.decode(ctx.scale.getText());
                    this.typeStack.push(LogicalTypes.decimal((int)precision, (int)scale).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES)));
                }
            }
        }

        @Override
        public void exitArrayType(IdlParser.ArrayTypeContext ctx) {
            this.typeStack.push(Schema.createArray((Schema)this.typeStack.pop()));
        }

        @Override
        public void exitMapType(IdlParser.MapTypeContext ctx) {
            this.typeStack.push(Schema.createMap((Schema)this.typeStack.pop()));
        }

        @Override
        public void enterUnionType(IdlParser.UnionTypeContext ctx) {
            this.typeStack.push(Schema.createUnion((Schema[])new Schema[0]));
        }

        @Override
        public void exitUnionType(IdlParser.UnionTypeContext ctx) {
            Schema type;
            ArrayList<Schema> types = new ArrayList<Schema>();
            while ((type = this.typeStack.pop()).getType() != Schema.Type.UNION) {
                types.add(type);
            }
            Collections.reverse(types);
            this.typeStack.push(Schema.createUnion(types));
        }

        @Override
        public void exitJsonValue(IdlParser.JsonValueContext ctx) {
            if (ctx.parent instanceof IdlParser.JsonArrayContext) {
                JsonNode value = this.jsonValues.pop();
                assert (this.jsonValues.peek() instanceof ArrayNode);
                ((ArrayNode)this.jsonValues.element()).add(value);
            }
        }

        @Override
        public void exitJsonLiteral(IdlParser.JsonLiteralContext ctx) {
            Token literal = ctx.literal;
            switch (literal.getType()) {
                case 26: {
                    this.jsonValues.push((JsonNode)NullNode.getInstance());
                    break;
                }
                case 27: {
                    this.jsonValues.push((JsonNode)BooleanNode.TRUE);
                    break;
                }
                case 28: {
                    this.jsonValues.push((JsonNode)BooleanNode.FALSE);
                    break;
                }
                case 55: {
                    String number = literal.getText().replace("_", "");
                    char lastChar = number.charAt(number.length() - 1);
                    boolean coerceToLong = false;
                    if (lastChar == 'l' || lastChar == 'L') {
                        coerceToLong = true;
                        number = number.substring(0, number.length() - 1);
                    }
                    long longNumber = Long.decode(number);
                    int intNumber = (int)longNumber;
                    this.jsonValues.push((JsonNode)(coerceToLong || (long)intNumber != longNumber ? new LongNode(longNumber) : new IntNode(intNumber)));
                    break;
                }
                case 56: {
                    this.jsonValues.push((JsonNode)new DoubleNode(Double.parseDouble(literal.getText())));
                    break;
                }
                default: {
                    this.jsonValues.push((JsonNode)new TextNode(this.getString(literal)));
                }
            }
        }

        @Override
        public void enterJsonArray(IdlParser.JsonArrayContext ctx) {
            this.jsonValues.push((JsonNode)new ArrayNode(null));
        }

        @Override
        public void enterJsonObject(IdlParser.JsonObjectContext ctx) {
            this.jsonValues.push((JsonNode)new ObjectNode(null));
        }

        @Override
        public void exitJsonPair(IdlParser.JsonPairContext ctx) {
            String name = this.getString(ctx.name);
            JsonNode value = this.jsonValues.pop();
            assert (this.jsonValues.peek() instanceof ObjectNode);
            ((ObjectNode)this.jsonValues.element()).set(name, value);
        }

        private String identifier(IdlParser.IdentifierContext ctx) {
            return ctx.word.getText().replace("`", "");
        }

        private String name(String identifier) {
            int dotPos = identifier.lastIndexOf(46);
            String name = identifier.substring(dotPos + 1);
            return this.validateName(name, true);
        }

        private String namespace(String identifier, String namespace) {
            String ns;
            int dotPos = identifier.lastIndexOf(46);
            String string = ns = dotPos < 0 ? namespace : identifier.substring(0, dotPos);
            if (ns == null) {
                return null;
            }
            int s = 0;
            int e = ns.indexOf(46);
            while (e > 0) {
                this.validateName(ns.substring(s, e), false);
                s = e + 1;
                e = ns.indexOf(46, s);
            }
            return ns;
        }

        private String validateName(String name, boolean isTypeName) {
            if (name == null) {
                throw new SchemaParseException("Null name");
            }
            if (!VALID_NAME.test(name)) {
                throw new SchemaParseException("Illegal name: " + name);
            }
            if (isTypeName && INVALID_TYPE_NAMES.contains(name)) {
                throw new SchemaParseException("Illegal name: " + name);
            }
            return name;
        }

        private String fullName(String namespace, String typeName) {
            int dotPos = typeName.lastIndexOf(46);
            if (dotPos > -1) {
                return typeName;
            }
            return namespace != null ? namespace + "." + typeName : typeName;
        }

        private String getString(Token stringToken) {
            String stringLiteral = stringToken.getText();
            String betweenQuotes = stringLiteral.substring(1, stringLiteral.length() - 1);
            return StringEscapeUtils.unescapeJava((String)betweenQuotes);
        }
    }

    private static class SchemaProperties {
        String contextNamespace;
        boolean withNamespace;
        String namespace;
        boolean withAliases;
        List<String> aliases;
        boolean withOrder;
        Schema.Field.Order order;
        Map<String, JsonNode> properties;

        public SchemaProperties(String contextNamespace, boolean withNamespace, boolean withAliases, boolean withOrder) {
            this.contextNamespace = contextNamespace;
            this.withNamespace = withNamespace;
            this.withAliases = withAliases;
            this.aliases = Collections.emptyList();
            this.withOrder = withOrder;
            this.order = Schema.Field.Order.ASCENDING;
            this.properties = new LinkedHashMap<String, JsonNode>();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void addProperty(String name, JsonNode value, Token firstValueToken) {
            if (this.withNamespace && "namespace".equals(name)) {
                if (!value.isTextual()) throw IdlReader.error("@namespace(...) must contain a String value", firstValueToken);
                this.namespace = value.textValue();
                return;
            } else if (this.withAliases && "aliases".equals(name)) {
                if (!value.isArray()) throw IdlReader.error("@aliases(...) must contain an array of String values", firstValueToken);
                ArrayList<String> result = new ArrayList<String>();
                Iterator elements = value.elements();
                elements.forEachRemaining(element -> {
                    if (!element.isTextual()) {
                        throw IdlReader.error("@aliases(...) must contain an array of String values", firstValueToken);
                    }
                    result.add(element.textValue());
                });
                this.aliases = result;
                return;
            } else if (this.withOrder && "order".equals(name)) {
                String orderValue;
                if (!value.isTextual()) throw IdlReader.error("@order(...) must contain a String value", firstValueToken);
                switch (orderValue = value.textValue().toUpperCase(Locale.ROOT)) {
                    case "ASCENDING": {
                        this.order = Schema.Field.Order.ASCENDING;
                        return;
                    }
                    case "DESCENDING": {
                        this.order = Schema.Field.Order.DESCENDING;
                        return;
                    }
                    case "IGNORE": {
                        this.order = Schema.Field.Order.IGNORE;
                        return;
                    }
                    default: {
                        throw IdlReader.error("@order(...) must contain \"ASCENDING\", \"DESCENDING\" or \"IGNORE\"", firstValueToken);
                    }
                }
            } else {
                this.properties.put(name, value);
            }
        }

        public String namespace() {
            return this.namespace == null ? this.contextNamespace : this.namespace;
        }

        public Schema.Field.Order order() {
            return this.order;
        }

        public void copyAliases(Consumer<String> addAlias) {
            this.aliases.forEach(addAlias);
        }

        public <T extends JsonProperties> T copyProperties(T jsonProperties) {
            Schema schema;
            LogicalType logicalType;
            this.properties.forEach((arg_0, arg_1) -> jsonProperties.addProp(arg_0, arg_1));
            if (jsonProperties instanceof Schema && (logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)(schema = (Schema)jsonProperties))) != null) {
                logicalType.addToSchema(schema);
            }
            return jsonProperties;
        }

        public boolean hasProperties() {
            return !this.properties.isEmpty();
        }
    }
}

