/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.idl.IdlFile;
import org.apache.avro.idl.IdlReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLogicalTypes {
    private Schema logicalTypeFields;

    @Before
    public void setup() throws IOException, URISyntaxException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        IdlFile idlFile = new IdlReader().parse(Objects.requireNonNull(cl.getResource("logicalTypes.avdl")).toURI());
        this.logicalTypeFields = idlFile.getNamedSchema("org.apache.avro.test.LogicalTypeFields");
    }

    @Test
    public void testDateBecomesLogicalType() {
        Assert.assertEquals((Object)LogicalTypes.date(), (Object)this.logicalTypeOfField("aDate"));
    }

    @Test
    public void testTimeMsBecomesLogicalType() {
        Assert.assertEquals((Object)LogicalTypes.timeMillis(), (Object)this.logicalTypeOfField("aTime"));
    }

    @Test
    public void testTimestampMsBecomesLogicalType() {
        Assert.assertEquals((Object)LogicalTypes.timestampMillis(), (Object)this.logicalTypeOfField("aTimestamp"));
    }

    @Test
    public void testLocalTimestampMsBecomesLogicalType() {
        Assert.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)this.logicalTypeOfField("aLocalTimestamp"));
    }

    @Test
    public void testDecimalBecomesLogicalType() {
        Assert.assertEquals((Object)LogicalTypes.decimal((int)6, (int)2), (Object)this.logicalTypeOfField("pocketMoney"));
    }

    @Test
    public void testUuidBecomesLogicalType() {
        Assert.assertEquals((Object)LogicalTypes.uuid(), (Object)this.logicalTypeOfField("identifier"));
    }

    @Test
    public void testAnnotatedLongBecomesLogicalType() {
        Assert.assertEquals((Object)LogicalTypes.timestampMicros(), (Object)this.logicalTypeOfField("anotherTimestamp"));
    }

    @Test
    public void testAnnotatedBytesFieldBecomesLogicalType() {
        Assert.assertEquals((Object)LogicalTypes.decimal((int)6, (int)2), (Object)this.logicalTypeOfField("allowance"));
    }

    @Test
    public void testIncorrectlyAnnotatedBytesFieldHasNoLogicalType() {
        Schema fieldSchema = this.logicalTypeFields.getField("byteArray").schema();
        Assert.assertNull((Object)fieldSchema.getLogicalType());
        Assert.assertEquals((Object)"decimal", (Object)fieldSchema.getObjectProp("logicalType"));
        Assert.assertEquals((Object)3000000000L, (Object)fieldSchema.getObjectProp("precision"));
        Assert.assertEquals((Object)0, (Object)fieldSchema.getObjectProp("scale"));
    }

    private LogicalType logicalTypeOfField(String name) {
        return this.logicalTypeFields.getField(name).schema().getLogicalType();
    }
}

