/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.idl.IdlFile;
import org.apache.avro.idl.IdlReader;
import org.apache.avro.idl.IdlUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IdlUtilsTest {
    @Test
    public void idlUtilsUtilitiesThrowRuntimeExceptionsOnProgrammerError() {
        Assertions.assertThrows(IllegalStateException.class, () -> IdlUtils.getField(Object.class, (String)"noSuchField"), (String)"Programmer error");
        Assertions.assertThrows(IllegalStateException.class, () -> IdlUtils.getFieldValue((Field)String.class.getDeclaredField("value"), (Object)"anything"), (String)"Programmer error");
        Assertions.assertEquals((Object)"foo", (Object)IdlUtils.uncheckExceptions(() -> "foo"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> IdlUtils.uncheckExceptions(() -> {
            throw new IllegalArgumentException("Oops");
        }), (String)"Oops");
        Assertions.assertThrows(AvroRuntimeException.class, () -> IdlUtils.uncheckExceptions(() -> {
            throw new IOException("Oops");
        }), (String)"Oops");
    }

    @Test
    public void validateHappyFlowForProtocol() throws IOException {
        Protocol protocol = this.parseIdlResource("idl_utils_test_protocol.avdl").getProtocol();
        StringWriter buffer = new StringWriter();
        IdlUtils.writeIdlProtocol((Writer)buffer, (Protocol)protocol);
        Assertions.assertEquals((Object)this.getResourceAsString("idl_utils_test_protocol.avdl"), (Object)buffer.toString());
    }

    private IdlFile parseIdlResource(String name) throws IOException {
        IdlFile idlFile;
        IdlReader idlReader = new IdlReader();
        try (InputStream stream = this.getClass().getResourceAsStream(name);){
            idlFile = idlReader.parse(Objects.requireNonNull(stream));
        }
        return idlFile;
    }

    private String getResourceAsString(String name) throws IOException {
        StringWriter schemaBuffer = new StringWriter();
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream(name)));){
            int charsRead;
            char[] buf = new char[1024];
            while ((charsRead = reader.read(buf)) > -1) {
                schemaBuffer.write(buf, 0, charsRead);
            }
        }
        return schemaBuffer.toString();
    }

    @Test
    public void validateHappyFlowForSingleSchema() throws IOException {
        IdlFile idlFile = this.parseIdlResource("idl_utils_test_schema.avdl");
        Schema mainSchema = idlFile.getMainSchema();
        StringWriter buffer = new StringWriter();
        IdlUtils.writeIdlSchema((Writer)buffer, (Schema)((Schema)mainSchema.getTypes().iterator().next()));
        Assertions.assertEquals((Object)this.getResourceAsString("idl_utils_test_schema.avdl"), (Object)buffer.toString());
    }

    @Test
    public void cannotWriteProtocolWithUnnamedTypes() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> IdlUtils.writeIdlProtocol((Writer)new StringWriter(), (Schema)Schema.create((Schema.Type)Schema.Type.STRING)));
    }

    @Test
    public void cannotWriteEmptyEnums() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> IdlUtils.writeIdlProtocol((Writer)new StringWriter(), (Schema)Schema.createEnum((String)"Single", null, (String)"naming", Collections.emptyList())));
    }

    @Test
    public void cannotWriteEmptyUnionTypes() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> IdlUtils.writeIdlProtocol((Writer)new StringWriter(), (Schema)Schema.createRecord((String)"Single", null, (String)"naming", (boolean)false, Collections.singletonList(new Schema.Field("field", Schema.createUnion((Schema[])new Schema[0]))))));
    }

    @Test
    public void validateNullToJson() throws IOException {
        Assertions.assertEquals((Object)"null", (Object)this.callToJson(JsonProperties.NULL_VALUE));
    }

    @Test
    public void validateMapToJson() throws IOException {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("key", "name");
        data.put("value", 81763);
        Assertions.assertEquals((Object)"{\"key\":\"name\",\"value\":81763}", (Object)this.callToJson(data));
    }

    @Test
    public void validateCollectionToJson() throws IOException {
        Assertions.assertEquals((Object)"[123,\"abc\"]", (Object)this.callToJson(Arrays.asList(123, "abc")));
    }

    @Test
    public void validateBytesToJson() throws IOException {
        Assertions.assertEquals((Object)"\"getalletjes\"", (Object)this.callToJson("getalletjes".getBytes(StandardCharsets.US_ASCII)));
    }

    @Test
    public void validateStringToJson() throws IOException {
        Assertions.assertEquals((Object)"\"foo\"", (Object)this.callToJson("foo"));
    }

    @Test
    public void validateEnumToJson() throws IOException {
        Assertions.assertEquals((Object)"\"FILE_NOT_FOUND\"", (Object)this.callToJson((Object)SingleValue.FILE_NOT_FOUND));
    }

    @Test
    public void validateDoubleToJson() throws IOException {
        Assertions.assertEquals((Object)"25000.025", (Object)this.callToJson(25000.025));
    }

    @Test
    public void validateFloatToJson() throws IOException {
        Assertions.assertEquals((Object)"15000.002", (Object)this.callToJson(Float.valueOf(15000.002f)));
    }

    @Test
    public void validateLongToJson() throws IOException {
        Assertions.assertEquals((Object)"7254378234", (Object)this.callToJson(7254378234L));
    }

    @Test
    public void validateIntegerToJson() throws IOException {
        Assertions.assertEquals((Object)"123", (Object)this.callToJson(123));
    }

    @Test
    public void validateBooleanToJson() throws IOException {
        Assertions.assertEquals((Object)"true", (Object)this.callToJson(true));
    }

    @Test
    public void validateUnknownCannotBeWrittenAsJson() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> this.callToJson(new Object()));
    }

    private String callToJson(Object datum) throws IOException {
        StringWriter buffer = new StringWriter();
        try (JsonGenerator generator = IdlUtils.MAPPER.createGenerator((Writer)buffer);){
            IdlUtils.MAPPER.writeValueAsString(datum);
        }
        return buffer.toString();
    }

    private static enum SingleValue {
        FILE_NOT_FOUND;

    }
}

