/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.idl.IdlFile;
import org.apache.avro.idl.IdlReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestIdlReader {
    private static final File TEST_DIR = new File(System.getProperty("test.idl.dir", "src/test/idl"));
    private static final File TEST_INPUT_DIR = new File(TEST_DIR, "input").getAbsoluteFile();
    private static final File TEST_OUTPUT_DIR = new File(TEST_DIR, "output");
    private static final String TEST_MODE = System.getProperty("test.idl.mode", "run");
    private static final File EXTRA_TEST_DIR = new File(TEST_DIR, "extra");
    private List<GenTest> tests;

    @Before
    public void loadTests() {
        Assert.assertTrue((boolean)TEST_DIR.exists());
        Assert.assertTrue((boolean)TEST_INPUT_DIR.exists());
        Assert.assertTrue((boolean)TEST_OUTPUT_DIR.exists());
        this.tests = new ArrayList<GenTest>();
        for (File inF : Objects.requireNonNull(TEST_INPUT_DIR.listFiles())) {
            if (!inF.getName().endsWith(".avdl") || inF.getName().startsWith(".")) continue;
            File outF = new File(TEST_OUTPUT_DIR, inF.getName().replaceFirst("_schema\\.avdl$", ".avsc").replaceFirst("\\.avdl$", ".avpr"));
            this.tests.add(new GenTest(inF, outF));
        }
    }

    @Test
    public void validateProtocolParsingResult() throws IOException {
        IdlFile idlFile = this.parseExtraIdlFile("protocolSyntax.avdl");
        Assert.assertEquals((long)1L, (long)idlFile.getNamedSchemas().size());
        idlFile.getNamedSchemas().keySet().forEach(System.out::println);
        Assert.assertNotNull((Object)idlFile.getNamedSchema("communication.Message"));
        Assert.assertNotNull((Object)idlFile.getProtocol());
        Assert.assertNull((Object)idlFile.getMainSchema());
    }

    @Test
    public void validateSchemaParsingResult() throws IOException {
        IdlFile idlFile = this.parseExtraIdlFile("schemaSyntax.avdl");
        Assert.assertEquals((long)1L, (long)idlFile.getNamedSchemas().size());
        idlFile.getNamedSchemas().keySet().forEach(System.out::println);
        Assert.assertNotNull((Object)idlFile.getNamedSchema("communication.Message"));
        Assert.assertNull((Object)idlFile.getProtocol());
        Schema mainSchema = idlFile.getMainSchema();
        Assert.assertEquals((Object)Schema.Type.ARRAY, (Object)mainSchema.getType());
        Assert.assertEquals((Object)idlFile.getNamedSchema("communication.Message"), (Object)mainSchema.getElementType());
    }

    @Test
    public void testDocCommentsAndWarnings() throws Exception {
        IdlFile idlFile = this.parseExtraIdlFile("../input/comments.avdl");
        Protocol protocol = idlFile.getProtocol();
        List warnings = idlFile.getWarnings();
        Assert.assertEquals((Object)"Documented Enum", (Object)protocol.getType("testing.DocumentedEnum").getDoc());
        Assert.assertEquals((Object)"Documented Fixed Type", (Object)protocol.getType("testing.DocumentedFixed").getDoc());
        Schema documentedError = protocol.getType("testing.DocumentedError");
        Assert.assertEquals((Object)"Documented Error", (Object)documentedError.getDoc());
        Assert.assertEquals((Object)"Documented Reason Field", (Object)documentedError.getField("reason").doc());
        Assert.assertEquals((Object)"Default Doc Explanation Field", (Object)documentedError.getField("explanation").doc());
        Map messages = protocol.getMessages();
        Protocol.Message documentedMethod = (Protocol.Message)messages.get("documentedMethod");
        Assert.assertEquals((Object)"Documented Method", (Object)documentedMethod.getDoc());
        Assert.assertEquals((Object)"Documented Parameter", (Object)documentedMethod.getRequest().getField("message").doc());
        Assert.assertEquals((Object)"Default Documented Parameter", (Object)documentedMethod.getRequest().getField("defMsg").doc());
        Assert.assertNull((Object)protocol.getType("testing.UndocumentedEnum").getDoc());
        Assert.assertNull((Object)protocol.getType("testing.UndocumentedFixed").getDoc());
        Assert.assertNull((Object)protocol.getType("testing.UndocumentedRecord").getDoc());
        Assert.assertNull((Object)((Protocol.Message)messages.get("undocumentedMethod")).getDoc());
        String pattern = "Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?";
        Assert.assertEquals(Arrays.asList(String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 21, 8), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 21, 45), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 22, 5), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 23, 5), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 24, 5), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 25, 5), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 26, 7), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 27, 7), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 28, 7), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 33, 7), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 34, 7), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 35, 5), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 36, 5), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 37, 7), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 42, 7), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 43, 7), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 46, 9), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 47, 5), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 54, 7), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 55, 7), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 58, 9), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 59, 7), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 60, 11), String.format("Line %d, char %d: Ignoring out-of-place documentation comment.%nDid you mean to use a multiline comment ( /* ... */ ) instead?", 61, 11)), (Object)warnings);
    }

    private IdlFile parseExtraIdlFile(String fileName) throws IOException {
        return new IdlReader().parse(EXTRA_TEST_DIR.toPath().resolve(fileName));
    }

    @Test
    public void runTests() {
        if (!"run".equals(TEST_MODE)) {
            return;
        }
        int failed = 0;
        for (GenTest t : this.tests) {
            try {
                t.run();
            }
            catch (Exception e) {
                ++failed;
                System.err.println("Failed: " + t.testName());
                e.printStackTrace(System.err);
            }
        }
        if (failed > 0) {
            Assert.fail((String)(failed + " tests failed"));
        }
    }

    @Test
    public void writeTests() throws Exception {
        if (!"write".equals(TEST_MODE)) {
            return;
        }
        for (GenTest t : this.tests) {
            t.write();
        }
    }

    private static class GenTest {
        private final File in;
        private final File expectedOut;

        public GenTest(File in, File expectedOut) {
            this.in = in;
            this.expectedOut = expectedOut;
        }

        private String generate() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL[] newPathURL = new URL[]{cl.getResource("putOnClassPath-test-resource.jar")};
            URLClassLoader ucl = new URLClassLoader(newPathURL, cl);
            Thread.currentThread().setContextClassLoader(ucl);
            try {
                IdlReader parser = new IdlReader();
                String string = parser.parse(this.in.toPath()).outputString();
                return string;
            }
            catch (IOException e) {
                throw new AssertionError(e.getMessage(), e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }

        public String testName() {
            return this.in.getName();
        }

        public void run() throws Exception {
            String output = this.generate();
            String slurped = GenTest.slurp(this.expectedOut);
            Assert.assertEquals((Object)slurped.trim(), (Object)output.replace("\\r", "").trim());
        }

        public void write() throws Exception {
            GenTest.writeFile(this.expectedOut, this.generate());
        }

        private static String slurp(File f) throws IOException {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));
            StringBuilder builder = new StringBuilder();
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
            in.close();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode json = mapper.readTree(builder.toString());
            return mapper.writer().writeValueAsString((Object)json);
        }

        private static void writeFile(File f, String s) throws IOException {
            FileWriter w = new FileWriter(f);
            w.write(s);
            w.close();
        }
    }
}

