/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.SchemaFormatter;
import org.apache.avro.SchemaParser;
import org.apache.avro.idl.IdlSchemaFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IdlSchemaFormatterFactoryTest {
    IdlSchemaFormatterFactoryTest() {
    }

    @Test
    void verifyIdlFormatting() throws IOException {
        SchemaFormatter idlFormatter = SchemaFormatter.getInstance((String)"idl");
        Assertions.assertEquals(IdlSchemaFormatter.class, idlFormatter.getClass());
        String formattedHappyFlowSchema = this.getResourceAsString("../util/idl_utils_test_schema.avdl");
        String schemaResourceName = "../util/idl_utils_test_schema.avdl";
        try (InputStream stream = this.getClass().getResourceAsStream(schemaResourceName);){
            Schema happyFlowSchema = new SchemaParser().parse((CharSequence)formattedHappyFlowSchema).mainSchema();
            String formatted = idlFormatter.format(happyFlowSchema).replaceAll("    ", "\t").replaceAll("\t", "  ");
            Assertions.assertEquals((Object)formattedHappyFlowSchema, (Object)formatted);
        }
    }

    private String getResourceAsString(String name) throws IOException {
        StringWriter schemaBuffer = new StringWriter();
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream(name)));){
            int charsRead;
            char[] buf = new char[1024];
            while ((charsRead = reader.read(buf)) > -1) {
                schemaBuffer.write(buf, 0, charsRead);
            }
        }
        return schemaBuffer.toString();
    }
}

