/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest;

import java.math.BigInteger;
import org.apache.avro.codegentest.AbstractSpecificRecordTest;
import org.apache.avro.codegentest.CustomDecimal;
import org.apache.avro.codegentest.CustomEnumType;
import org.apache.avro.codegentest.FixedSizeString;
import org.apache.avro.codegentest.testdata.CustomConversionWithLogicalTypes;
import org.apache.avro.codegentest.testdata.LogicalTypesWithCustomConversion;
import org.apache.avro.codegentest.testdata.LogicalTypesWithCustomConversionIdl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCustomConversion
extends AbstractSpecificRecordTest {
    @Test
    void nullValues() {
        LogicalTypesWithCustomConversion instanceOfGeneratedClass = LogicalTypesWithCustomConversion.newBuilder().setNonNullCustomField(new CustomDecimal(BigInteger.valueOf(100L), 2)).setNonNullFixedSizeString(new FixedSizeString("test")).build();
        this.verifySerDeAndStandardMethods(instanceOfGeneratedClass);
    }

    @Test
    void nullValuesIdl() {
        LogicalTypesWithCustomConversionIdl instanceOfGeneratedClass = LogicalTypesWithCustomConversionIdl.newBuilder().setNonNullCustomField(new CustomDecimal(BigInteger.valueOf(100L), 2)).setNonNullFixedSizeString(new FixedSizeString("test")).build();
        this.verifySerDeAndStandardMethods(instanceOfGeneratedClass);
    }

    @Test
    void nonNullValues() {
        LogicalTypesWithCustomConversion instanceOfGeneratedClass = LogicalTypesWithCustomConversion.newBuilder().setNonNullCustomField(new CustomDecimal(BigInteger.valueOf(100L), 2)).setNullableCustomField(new CustomDecimal(BigInteger.valueOf(3000L), 2)).setNonNullFixedSizeString(new FixedSizeString("test")).setNullableFixedSizeString(new FixedSizeString("test2")).build();
        this.verifySerDeAndStandardMethods(instanceOfGeneratedClass);
    }

    @Test
    void stringViolatesLimit() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            LogicalTypesWithCustomConversion instanceOfGeneratedClass = LogicalTypesWithCustomConversion.newBuilder().setNonNullCustomField(new CustomDecimal(BigInteger.valueOf(100L), 2)).setNonNullFixedSizeString(new FixedSizeString("")).build();
            this.verifySerDeAndStandardMethods(instanceOfGeneratedClass);
        });
    }

    @Test
    void customConversionWithCustomLogicalType() {
        CustomConversionWithLogicalTypes customConversionWithLogicalTypes = CustomConversionWithLogicalTypes.newBuilder().setCustomEnum(new CustomEnumType("TWO")).build();
        this.verifySerDeAndStandardMethods(customConversionWithLogicalTypes);
    }
}

