/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.junit.jupiter.api.Assertions;

abstract class AbstractSpecificRecordTest {
    AbstractSpecificRecordTest() {
    }

    <T extends SpecificRecordBase> void verifySerDeAndStandardMethods(T original) {
        SpecificDatumWriter datumWriterFromSchema = new SpecificDatumWriter(original.getSchema());
        SpecificDatumReader datumReaderFromSchema = new SpecificDatumReader(original.getSchema(), original.getSchema());
        this.verifySerDeAndStandardMethods(original, datumWriterFromSchema, datumReaderFromSchema);
        SpecificDatumWriter datumWriterFromClass = new SpecificDatumWriter(original.getClass());
        SpecificDatumReader datumReaderFromClass = new SpecificDatumReader(original.getClass());
        this.verifySerDeAndStandardMethods(original, datumWriterFromClass, datumReaderFromClass);
    }

    private <T extends SpecificRecordBase> void verifySerDeAndStandardMethods(T original, SpecificDatumWriter<T> datumWriter, SpecificDatumReader<T> datumReader) {
        byte[] serialized = this.serialize(original, datumWriter);
        T copy = this.deserialize(serialized, datumReader);
        Assertions.assertEquals(original, copy);
        Assertions.assertEquals((int)original.hashCode(), (int)copy.hashCode());
        Assertions.assertEquals((Object)original.toString(), (Object)copy.toString());
    }

    private <T extends SpecificRecordBase> byte[] serialize(T object, SpecificDatumWriter<T> datumWriter) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            datumWriter.write(object, (Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)outputStream, null));
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T extends SpecificRecordBase> T deserialize(byte[] bytes, SpecificDatumReader<T> datumReader) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return (T)((SpecificRecordBase)datumReader.read(null, (Decoder)DecoderFactory.get().directBinaryDecoder((InputStream)byteArrayInputStream, null)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

