/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest.testdata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.codegentest.CustomDecimal;
import org.apache.avro.codegentest.CustomDecimalConversion;
import org.apache.avro.codegentest.FixedSizeString;
import org.apache.avro.codegentest.FixedSizeStringConversion;
import org.apache.avro.codegentest.FixedSizeStringFactory;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class LogicalTypesWithCustomConversion
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -4747523416189543339L;
    public static final Schema SCHEMA$;
    private static final SpecificData MODEL$;
    private static final BinaryMessageEncoder<LogicalTypesWithCustomConversion> ENCODER;
    private static final BinaryMessageDecoder<LogicalTypesWithCustomConversion> DECODER;
    private CustomDecimal nullableCustomField;
    private CustomDecimal nonNullCustomField;
    private FixedSizeString nullableFixedSizeString;
    private FixedSizeString nonNullFixedSizeString;
    private static final Conversion<?>[] conversions;
    private static final DatumWriter<LogicalTypesWithCustomConversion> WRITER$;
    private static final DatumReader<LogicalTypesWithCustomConversion> READER$;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<LogicalTypesWithCustomConversion> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<LogicalTypesWithCustomConversion> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<LogicalTypesWithCustomConversion> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static LogicalTypesWithCustomConversion fromByteBuffer(ByteBuffer b) throws IOException {
        return (LogicalTypesWithCustomConversion)((Object)DECODER.decode(b));
    }

    public LogicalTypesWithCustomConversion() {
    }

    public LogicalTypesWithCustomConversion(CustomDecimal nullableCustomField, CustomDecimal nonNullCustomField, FixedSizeString nullableFixedSizeString, FixedSizeString nonNullFixedSizeString) {
        this.nullableCustomField = nullableCustomField;
        this.nonNullCustomField = nonNullCustomField;
        this.nullableFixedSizeString = nullableFixedSizeString;
        this.nonNullFixedSizeString = nonNullFixedSizeString;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.nullableCustomField;
            }
            case 1: {
                return this.nonNullCustomField;
            }
            case 2: {
                return this.nullableFixedSizeString;
            }
            case 3: {
                return this.nonNullFixedSizeString;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public Conversion<?> getConversion(int field) {
        return conversions[field];
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.nullableCustomField = (CustomDecimal)value$;
                break;
            }
            case 1: {
                this.nonNullCustomField = (CustomDecimal)value$;
                break;
            }
            case 2: {
                this.nullableFixedSizeString = (FixedSizeString)value$;
                break;
            }
            case 3: {
                this.nonNullFixedSizeString = (FixedSizeString)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public CustomDecimal getNullableCustomField() {
        return this.nullableCustomField;
    }

    public void setNullableCustomField(CustomDecimal value) {
        this.nullableCustomField = value;
    }

    public CustomDecimal getNonNullCustomField() {
        return this.nonNullCustomField;
    }

    public void setNonNullCustomField(CustomDecimal value) {
        this.nonNullCustomField = value;
    }

    public FixedSizeString getNullableFixedSizeString() {
        return this.nullableFixedSizeString;
    }

    public void setNullableFixedSizeString(FixedSizeString value) {
        this.nullableFixedSizeString = value;
    }

    public FixedSizeString getNonNullFixedSizeString() {
        return this.nonNullFixedSizeString;
    }

    public void setNonNullFixedSizeString(FixedSizeString value) {
        this.nonNullFixedSizeString = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(LogicalTypesWithCustomConversion other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    static {
        LogicalTypes.register((String)"fixed-size-string", (LogicalTypes.LogicalTypeFactory)new FixedSizeStringFactory());
        SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"LogicalTypesWithCustomConversion\",\"namespace\":\"org.apache.avro.codegentest.testdata\",\"doc\":\"Test unions with logical types in generated Java classes\",\"fields\":[{\"name\":\"nullableCustomField\",\"type\":[\"null\",{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":9,\"scale\":2}],\"default\":null},{\"name\":\"nonNullCustomField\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":9,\"scale\":2}},{\"name\":\"nullableFixedSizeString\",\"type\":[\"null\",{\"type\":\"bytes\",\"logicalType\":\"fixed-size-string\",\"minLength\":1,\"maxLength\":50}],\"default\":null},{\"name\":\"nonNullFixedSizeString\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"fixed-size-string\",\"minLength\":1,\"maxLength\":50}}]}");
        MODEL$ = new SpecificData();
        MODEL$.addLogicalTypeConversion((Conversion)new CustomDecimalConversion());
        MODEL$.addLogicalTypeConversion((Conversion)new FixedSizeStringConversion());
        ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
        DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
        conversions = new Conversion[]{null, new CustomDecimalConversion(), null, new FixedSizeStringConversion(), null};
        WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
        READER$ = MODEL$.createDatumReader(SCHEMA$);
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<LogicalTypesWithCustomConversion>
    implements RecordBuilder<LogicalTypesWithCustomConversion> {
        private CustomDecimal nullableCustomField;
        private CustomDecimal nonNullCustomField;
        private FixedSizeString nullableFixedSizeString;
        private FixedSizeString nonNullFixedSizeString;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.nullableCustomField)) {
                this.nullableCustomField = (CustomDecimal)this.data().deepCopy(this.fields()[0].schema(), (Object)other.nullableCustomField);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.nonNullCustomField)) {
                this.nonNullCustomField = (CustomDecimal)this.data().deepCopy(this.fields()[1].schema(), (Object)other.nonNullCustomField);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.nullableFixedSizeString)) {
                this.nullableFixedSizeString = (FixedSizeString)this.data().deepCopy(this.fields()[2].schema(), (Object)other.nullableFixedSizeString);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.nonNullFixedSizeString)) {
                this.nonNullFixedSizeString = (FixedSizeString)this.data().deepCopy(this.fields()[3].schema(), (Object)other.nonNullFixedSizeString);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(LogicalTypesWithCustomConversion other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.nullableCustomField)) {
                this.nullableCustomField = (CustomDecimal)this.data().deepCopy(this.fields()[0].schema(), (Object)other.nullableCustomField);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.nonNullCustomField)) {
                this.nonNullCustomField = (CustomDecimal)this.data().deepCopy(this.fields()[1].schema(), (Object)other.nonNullCustomField);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.nullableFixedSizeString)) {
                this.nullableFixedSizeString = (FixedSizeString)this.data().deepCopy(this.fields()[2].schema(), (Object)other.nullableFixedSizeString);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.nonNullFixedSizeString)) {
                this.nonNullFixedSizeString = (FixedSizeString)this.data().deepCopy(this.fields()[3].schema(), (Object)other.nonNullFixedSizeString);
                this.fieldSetFlags()[3] = true;
            }
        }

        public CustomDecimal getNullableCustomField() {
            return this.nullableCustomField;
        }

        public Builder setNullableCustomField(CustomDecimal value) {
            this.validate(this.fields()[0], value);
            this.nullableCustomField = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasNullableCustomField() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearNullableCustomField() {
            this.nullableCustomField = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public CustomDecimal getNonNullCustomField() {
            return this.nonNullCustomField;
        }

        public Builder setNonNullCustomField(CustomDecimal value) {
            this.validate(this.fields()[1], value);
            this.nonNullCustomField = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasNonNullCustomField() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearNonNullCustomField() {
            this.nonNullCustomField = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public FixedSizeString getNullableFixedSizeString() {
            return this.nullableFixedSizeString;
        }

        public Builder setNullableFixedSizeString(FixedSizeString value) {
            this.validate(this.fields()[2], value);
            this.nullableFixedSizeString = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasNullableFixedSizeString() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearNullableFixedSizeString() {
            this.nullableFixedSizeString = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public FixedSizeString getNonNullFixedSizeString() {
            return this.nonNullFixedSizeString;
        }

        public Builder setNonNullFixedSizeString(FixedSizeString value) {
            this.validate(this.fields()[3], value);
            this.nonNullFixedSizeString = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasNonNullFixedSizeString() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearNonNullFixedSizeString() {
            this.nonNullFixedSizeString = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public LogicalTypesWithCustomConversion build() {
            try {
                LogicalTypesWithCustomConversion record = new LogicalTypesWithCustomConversion();
                record.nullableCustomField = this.fieldSetFlags()[0] ? this.nullableCustomField : (CustomDecimal)this.defaultValue(this.fields()[0]);
                record.nonNullCustomField = this.fieldSetFlags()[1] ? this.nonNullCustomField : (CustomDecimal)this.defaultValue(this.fields()[1]);
                record.nullableFixedSizeString = this.fieldSetFlags()[2] ? this.nullableFixedSizeString : (FixedSizeString)this.defaultValue(this.fields()[2]);
                record.nonNullFixedSizeString = this.fieldSetFlags()[3] ? this.nonNullFixedSizeString : (FixedSizeString)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

