/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest;

import java.math.BigInteger;
import java.time.LocalDate;
import java.util.Collections;
import org.apache.avro.codegentest.AbstractSpecificRecordTest;
import org.apache.avro.codegentest.CustomDecimal;
import org.apache.avro.codegentest.testdata.NestedLogicalTypesArray;
import org.apache.avro.codegentest.testdata.NestedLogicalTypesMap;
import org.apache.avro.codegentest.testdata.NestedLogicalTypesRecord;
import org.apache.avro.codegentest.testdata.NestedLogicalTypesUnion;
import org.apache.avro.codegentest.testdata.NestedLogicalTypesUnionFixedDecimal;
import org.apache.avro.codegentest.testdata.NestedRecord;
import org.apache.avro.codegentest.testdata.NullableLogicalTypesArray;
import org.apache.avro.codegentest.testdata.RecordInArray;
import org.apache.avro.codegentest.testdata.RecordInMap;
import org.apache.avro.codegentest.testdata.RecordInUnion;
import org.junit.jupiter.api.Test;

public class TestNestedLogicalTypes
extends AbstractSpecificRecordTest {
    @Test
    void nullableLogicalTypeInNestedRecord() {
        NestedLogicalTypesRecord nestedLogicalTypesRecord = NestedLogicalTypesRecord.newBuilder().setNestedRecord(NestedRecord.newBuilder().setNullableDateField(LocalDate.now()).build()).build();
        this.verifySerDeAndStandardMethods(nestedLogicalTypesRecord);
    }

    @Test
    void nullableLogicalTypeInArray() {
        NullableLogicalTypesArray logicalTypesArray = NullableLogicalTypesArray.newBuilder().setArrayOfLogicalType(Collections.singletonList(LocalDate.now())).build();
        this.verifySerDeAndStandardMethods(logicalTypesArray);
    }

    @Test
    void nullableLogicalTypeInRecordInArray() {
        NestedLogicalTypesArray nestedLogicalTypesArray = NestedLogicalTypesArray.newBuilder().setArrayOfRecords(Collections.singletonList(RecordInArray.newBuilder().setNullableDateField(LocalDate.now()).build())).build();
        this.verifySerDeAndStandardMethods(nestedLogicalTypesArray);
    }

    @Test
    void nullableLogicalTypeInRecordInUnion() {
        NestedLogicalTypesUnion nestedLogicalTypesUnion = NestedLogicalTypesUnion.newBuilder().setUnionOfRecords(RecordInUnion.newBuilder().setNullableDateField(LocalDate.now()).build()).build();
        this.verifySerDeAndStandardMethods(nestedLogicalTypesUnion);
    }

    @Test
    void nullableLogicalTypeInRecordInMap() {
        NestedLogicalTypesMap nestedLogicalTypesMap = NestedLogicalTypesMap.newBuilder().setMapOfRecords(Collections.singletonMap("key", RecordInMap.newBuilder().setNullableDateField(LocalDate.now()).build())).build();
        this.verifySerDeAndStandardMethods(nestedLogicalTypesMap);
    }

    @Test
    void nullableLogicalTypeInRecordInFixedDecimal() {
        NestedLogicalTypesUnionFixedDecimal nestedLogicalTypesUnionFixedDecimal = NestedLogicalTypesUnionFixedDecimal.newBuilder().setUnionOfFixedDecimal(new CustomDecimal(BigInteger.TEN, 15)).build();
        this.verifySerDeAndStandardMethods(nestedLogicalTypesUnionFixedDecimal);
    }
}

